/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.api;

import com.datatorrent.api.Attribute;
import com.datatorrent.api.Operator;
import com.datatorrent.api.StatsListener;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

public interface Partitioner<T> {
    public Collection<Partition<T>> definePartitions(Collection<Partition<T>> var1, PartitioningContext var2);

    public void partitioned(Map<Integer, Partition<T>> var1);

    public static interface PartitioningContext {
        public int getParallelPartitionCount();

        public List<Operator.InputPort<?>> getInputPorts();
    }

    public static interface Partition<T> {
        public Map<Operator.InputPort<?>, PartitionKeys> getPartitionKeys();

        public int getLoad();

        public StatsListener.BatchedOperatorStats getStats();

        public T getPartitionedInstance();

        public Attribute.AttributeMap getAttributes();
    }

    public static class PartitionKeys
    implements Serializable {
        private static final long serialVersionUID = 201312271835L;
        public final int mask;
        public final Set<Integer> partitions;

        public PartitionKeys(int mask, Set<Integer> partitions) {
            this.mask = mask;
            this.partitions = partitions;
        }

        public int hashCode() {
            int hash = 7;
            hash = 79 * hash + this.mask;
            hash = 79 * hash + (this.partitions != null ? this.partitions.hashCode() : 0);
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PartitionKeys other = (PartitionKeys)obj;
            if (this.mask != other.mask) {
                return false;
            }
            return this.partitions == other.partitions || this.partitions != null && this.partitions.equals(other.partitions);
        }

        public String toString() {
            return "[" + this.mask + "," + this.partitions + "]";
        }
    }
}

