/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.api;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Map;

public interface Stats
extends Serializable {
    public static final long INVALID_TIME_MILLIS = -1L;

    public static class OperatorStats
    implements Stats {
        public long windowId;
        public Checkpoint checkpoint;
        public ArrayList<PortStats> inputPorts;
        public ArrayList<PortStats> outputPorts;
        public long cpuTimeUsed;
        public CheckpointStats checkpointStats;
        @Deprecated
        public Object counters;
        public Map<String, Object> metrics;
        public String recordingId;
        private static final long serialVersionUID = 201309131905L;

        public String toString() {
            return "OperatorStats{windowId=" + this.windowId + ", checkpointedWindowId=" + this.checkpoint + ", inputPorts=" + this.inputPorts + ", outputPorts=" + this.outputPorts + ", cpuTimeUsed=" + this.cpuTimeUsed + ", checkpointStats=" + this.checkpointStats + '}';
        }

        public static class PortStats
        implements Stats {
            private static final long serialVersionUID = 201309131906L;
            public final String id;
            public int tupleCount;
            public long endWindowTimestamp;
            public long bufferServerBytes;
            public int queueSize;
            public String recordingId;

            public PortStats(String id) {
                this.id = id;
            }

            public String toString() {
                return "PortStats{portname=" + this.id + ", processedCount=" + this.tupleCount + ", bufferServerBytes = " + this.bufferServerBytes + ", queueSize = " + this.queueSize + ", endWindowTimestamp=" + this.endWindowTimestamp + '}';
            }
        }
    }

    public static class CheckpointStats
    implements Stats {
        public long checkpointStartTime;
        public long checkpointTime;

        public String toString() {
            return "CheckpointStats{checkpointStartTime=" + this.checkpointStartTime + ", checkpointTime=" + this.checkpointTime + '}';
        }
    }

    public static interface Checkpoint
    extends Serializable {
        public long getWindowId();
    }
}

