/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.bufferserver.client;

import com.datatorrent.bufferserver.client.AuthClient;
import com.datatorrent.bufferserver.packet.MessageType;
import com.datatorrent.bufferserver.packet.PurgeRequestTuple;
import com.datatorrent.bufferserver.packet.ResetRequestTuple;
import com.datatorrent.bufferserver.packet.Tuple;
import com.datatorrent.bufferserver.util.Codec;
import com.datatorrent.netlet.util.Slice;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Controller
extends AuthClient {
    String id;
    private static final Logger logger = LoggerFactory.getLogger(Controller.class);

    public Controller(String id) {
        super(1024, 1024);
        this.id = id;
    }

    public void purge(String version, String sourceId, long windowId) {
        this.sendAuthenticate();
        this.write(PurgeRequestTuple.getSerializedRequest(version, sourceId, windowId));
        logger.debug("Sent purge request sourceId = {}, windowId = {}", (Object)sourceId, (Object)Codec.getStringWindowId(windowId));
    }

    public void reset(String version, String sourceId, long windowId) {
        this.sendAuthenticate();
        this.write(ResetRequestTuple.getSerializedRequest(version, sourceId, windowId));
        logger.debug("Sent reset request sourceId = {}, windowId = {}", (Object)sourceId, (Object)Codec.getStringWindowId(windowId));
    }

    public void onMessage(byte[] buffer, int offset, int size) {
        Tuple t = Tuple.getTuple(buffer, offset, size);
        assert (t.getType() == MessageType.PAYLOAD);
        Slice f = t.getData();
        this.onMessage(new String(f.buffer, f.offset, f.length));
    }

    public abstract void onMessage(String var1);

    public String toString() {
        return "Controller{id=" + this.id + '}';
    }
}

