/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.bufferserver.internal;

import com.datatorrent.bufferserver.util.SerializedData;
import com.datatorrent.netlet.AbstractLengthPrependerClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PhysicalNode {
    public static final int BUFFER_SIZE = 8192;
    private final long starttime;
    private final AbstractLengthPrependerClient client;
    private final long processedMessageCount;
    private SerializedData blocker;
    private static final Logger logger = LoggerFactory.getLogger(PhysicalNode.class);

    public PhysicalNode(AbstractLengthPrependerClient client) {
        this.client = client;
        this.starttime = System.currentTimeMillis();
        this.processedMessageCount = 0L;
    }

    public long getstartTime() {
        return this.starttime;
    }

    public long getUptime() {
        return System.currentTimeMillis() - this.starttime;
    }

    public boolean send(SerializedData d) {
        if (d.offset == d.dataOffset ? this.client.write(d.buffer, d.offset, d.length) : this.client.send(d.buffer, d.offset, d.length)) {
            return true;
        }
        this.blocker = d;
        return false;
    }

    public boolean unblock() {
        if (this.blocker == null) {
            return true;
        }
        if (this.send(this.blocker)) {
            this.blocker = null;
            return true;
        }
        return false;
    }

    public boolean isBlocked() {
        return this.blocker != null;
    }

    public final long getProcessedMessageCount() {
        return this.processedMessageCount;
    }

    public boolean equals(Object o) {
        return o == this || o.getClass() == this.getClass() && o.hashCode() == this.hashCode();
    }

    public final int getId() {
        return this.client.hashCode();
    }

    public final int hashCode() {
        return this.client.hashCode();
    }

    public AbstractLengthPrependerClient getClient() {
        return this.client;
    }

    public String toString() {
        return "PhysicalNode." + this.client;
    }
}

