/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.bufferserver.util;

public class BitVector {
    final int mask;
    final int bits;

    public BitVector(int bits, int mask) {
        this.mask = mask;
        this.bits = bits & mask;
    }

    public int hashCode() {
        int hash = 3;
        hash = 37 * hash + this.mask;
        hash = 37 * hash + this.bits;
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BitVector other = (BitVector)obj;
        if (this.mask != other.mask) {
            return false;
        }
        return this.bits == other.bits;
    }

    public boolean matches(int value) {
        return (value & this.mask) == this.bits;
    }

    public String toString() {
        return "BitVector{mask=" + Integer.toBinaryString(this.mask) + ", bits=" + Integer.toBinaryString(this.bits) + '}';
    }
}

