/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.common.util;

import com.datatorrent.common.util.FSStorageAgent;
import com.google.common.base.Throwables;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectStreamException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.EnumSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncFSStorageAgent
extends FSStorageAgent {
    private final transient Configuration conf;
    private volatile transient String localBasePath;
    private boolean syncCheckpoint = false;
    private static final long serialVersionUID = 201507241610L;
    private static final Logger logger = LoggerFactory.getLogger(AsyncFSStorageAgent.class);

    private AsyncFSStorageAgent() {
        this.conf = null;
    }

    public AsyncFSStorageAgent(String path, Configuration conf) {
        super(path, conf);
        this.conf = conf == null ? new Configuration() : conf;
    }

    @Deprecated
    public AsyncFSStorageAgent(String localBasePath, String path, Configuration conf) {
        this(path, conf);
        this.localBasePath = localBasePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save(Object object, int operatorId, long windowId) throws IOException {
        String operatorIdStr;
        File directory;
        if (this.syncCheckpoint) {
            super.save(object, operatorId, windowId);
            return;
        }
        if (this.localBasePath == null) {
            AsyncFSStorageAgent asyncFSStorageAgent = this;
            synchronized (asyncFSStorageAgent) {
                if (this.localBasePath == null) {
                    this.localBasePath = Files.createTempDirectory("chkp", new FileAttribute[0]).toString();
                    logger.info("using {} as the basepath for checkpointing.", (Object)this.localBasePath);
                }
            }
        }
        if (!(directory = new File(this.localBasePath, operatorIdStr = String.valueOf(operatorId))).exists()) {
            directory.mkdirs();
        }
        try (FileOutputStream stream = new FileOutputStream(new File(directory, String.valueOf(windowId)));){
            AsyncFSStorageAgent.store(stream, object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void copyToHDFS(int operatorId, long windowId) throws IOException {
        boolean stateSaved;
        FSDataOutputStream stream;
        File srcFile;
        Path lPath;
        String window;
        String operatorIdStr;
        block20: {
            if (this.localBasePath == null) {
                throw new AssertionError((Object)"save() was not called before copyToHDFS");
            }
            operatorIdStr = String.valueOf(operatorId);
            File directory = new File(this.localBasePath, operatorIdStr);
            window = Long.toHexString(windowId);
            lPath = new Path(this.path + "/" + operatorIdStr + "/" + "_tmp");
            srcFile = new File(directory, String.valueOf(windowId));
            stream = null;
            stateSaved = false;
            stream = this.fileContext.create(lPath, EnumSet.of(CreateFlag.CREATE, CreateFlag.OVERWRITE), new Options.CreateOpts[]{Options.CreateOpts.CreateParent.createParent()});
            FileInputStream in = null;
            try {
                in = new FileInputStream(srcFile);
                IOUtils.copyBytes((InputStream)in, (OutputStream)stream, (Configuration)this.conf, (boolean)false);
            }
            catch (Throwable throwable) {
                IOUtils.closeStream(in);
                throw throwable;
            }
            IOUtils.closeStream((Closeable)in);
            stateSaved = true;
            try {
                if (stream != null) {
                    stream.close();
                }
                if (!stateSaved) break block20;
            }
            catch (IOException ie) {
                try {
                    stateSaved = false;
                    throw new RuntimeException(ie);
                }
                catch (Throwable throwable) {
                    if (stateSaved) {
                        this.fileContext.rename(lPath, new Path(this.path + "/" + operatorIdStr + "/" + window), new Options.Rename[]{Options.Rename.OVERWRITE});
                    }
                    FileUtil.fullyDelete((File)srcFile);
                    throw throwable;
                }
            }
            this.fileContext.rename(lPath, new Path(this.path + "/" + operatorIdStr + "/" + window), new Options.Rename[]{Options.Rename.OVERWRITE});
        }
        FileUtil.fullyDelete((File)srcFile);
        return;
        catch (Throwable t) {
            try {
                logger.debug("while saving {} {}", new Object[]{operatorId, window, t});
                stateSaved = false;
                throw Throwables.propagate((Throwable)t);
            }
            catch (Throwable throwable) {
                block21: {
                    try {
                        if (stream != null) {
                            stream.close();
                        }
                        if (!stateSaved) break block21;
                    }
                    catch (IOException ie) {
                        try {
                            stateSaved = false;
                            throw new RuntimeException(ie);
                        }
                        catch (Throwable throwable2) {
                            if (stateSaved) {
                                this.fileContext.rename(lPath, new Path(this.path + "/" + operatorIdStr + "/" + window), new Options.Rename[]{Options.Rename.OVERWRITE});
                            }
                            FileUtil.fullyDelete((File)srcFile);
                            throw throwable2;
                        }
                    }
                    this.fileContext.rename(lPath, new Path(this.path + "/" + operatorIdStr + "/" + window), new Options.Rename[]{Options.Rename.OVERWRITE});
                }
                FileUtil.fullyDelete((File)srcFile);
                throw throwable;
            }
        }
    }

    @Override
    public Object readResolve() throws ObjectStreamException {
        AsyncFSStorageAgent asyncFSStorageAgent = new AsyncFSStorageAgent(this.path, null);
        asyncFSStorageAgent.setSyncCheckpoint(this.syncCheckpoint);
        return asyncFSStorageAgent;
    }

    public boolean isSyncCheckpoint() {
        return this.syncCheckpoint;
    }

    public void setSyncCheckpoint(boolean syncCheckpoint) {
        this.syncCheckpoint = syncCheckpoint;
    }
}

