/*
 * Decompiled with CFR 0.152.
 */
package org.apache.apex.shaded.ning19.com.ning.http.client;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.apex.shaded.ning19.com.ning.http.client.FluentCaseInsensitiveStringsMap;
import org.apache.apex.shaded.ning19.com.ning.http.client.HttpResponseBodyPart;
import org.apache.apex.shaded.ning19.com.ning.http.client.HttpResponseHeaders;
import org.apache.apex.shaded.ning19.com.ning.http.client.HttpResponseStatus;
import org.apache.apex.shaded.ning19.com.ning.http.client.cookie.Cookie;
import org.apache.apex.shaded.ning19.com.ning.http.client.uri.Uri;

public interface Response {
    public int getStatusCode();

    public String getStatusText();

    public byte[] getResponseBodyAsBytes() throws IOException;

    public ByteBuffer getResponseBodyAsByteBuffer() throws IOException;

    public InputStream getResponseBodyAsStream() throws IOException;

    public String getResponseBodyExcerpt(int var1, String var2) throws IOException;

    public String getResponseBody(String var1) throws IOException;

    public String getResponseBodyExcerpt(int var1) throws IOException;

    public String getResponseBody() throws IOException;

    public Uri getUri();

    public String getContentType();

    public String getHeader(String var1);

    public List<String> getHeaders(String var1);

    public FluentCaseInsensitiveStringsMap getHeaders();

    public boolean isRedirected();

    public String toString();

    public List<Cookie> getCookies();

    public boolean hasResponseStatus();

    public boolean hasResponseHeaders();

    public boolean hasResponseBody();

    public static class ResponseBuilder {
        private final List<HttpResponseBodyPart> bodyParts = new ArrayList<HttpResponseBodyPart>();
        private HttpResponseStatus status;
        private HttpResponseHeaders headers;

        public ResponseBuilder accumulate(HttpResponseStatus status) {
            this.status = status;
            return this;
        }

        public ResponseBuilder accumulate(HttpResponseHeaders headers) {
            this.headers = headers;
            return this;
        }

        public ResponseBuilder accumulate(HttpResponseBodyPart bodyPart) {
            if (bodyPart.length() > 0) {
                this.bodyParts.add(bodyPart);
            }
            return this;
        }

        public Response build() {
            return this.status == null ? null : this.status.prepareResponse(this.headers, this.bodyParts);
        }

        public void reset() {
            this.bodyParts.clear();
            this.status = null;
            this.headers = null;
        }
    }
}

