/*
 * Decompiled with CFR 0.152.
 */
package org.apache.apex.shaded.ning19.com.ning.http.client.consumers;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import org.apache.apex.shaded.ning19.com.ning.http.client.ResumableBodyConsumer;

public class FileBodyConsumer
implements ResumableBodyConsumer {
    private final RandomAccessFile file;

    public FileBodyConsumer(RandomAccessFile file) {
        this.file = file;
    }

    @Override
    public void consume(ByteBuffer byteBuffer) throws IOException {
        this.file.write(byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), byteBuffer.remaining());
    }

    @Override
    public void close() throws IOException {
        this.file.close();
    }

    @Override
    public long getTransferredBytes() throws IOException {
        return this.file.length();
    }

    @Override
    public void resume() throws IOException {
        this.file.seek(this.getTransferredBytes());
    }
}

