/*
 * Decompiled with CFR 0.152.
 */
package org.apache.apex.shaded.ning19.com.ning.http.client.providers.netty.request.body;

import java.io.IOException;
import java.io.InputStream;
import org.apache.apex.shaded.ning19.com.ning.http.client.AsyncHttpClientConfig;
import org.apache.apex.shaded.ning19.com.ning.http.client.Body;
import org.apache.apex.shaded.ning19.com.ning.http.client.generators.InputStreamBodyGenerator;
import org.apache.apex.shaded.ning19.com.ning.http.client.providers.netty.future.NettyResponseFuture;
import org.apache.apex.shaded.ning19.com.ning.http.client.providers.netty.request.ProgressListener;
import org.apache.apex.shaded.ning19.com.ning.http.client.providers.netty.request.body.BodyChunkedInput;
import org.apache.apex.shaded.ning19.com.ning.http.client.providers.netty.request.body.NettyBody;
import org.apache.apex.shaded.ning19.com.ning.http.util.MiscUtils;
import org.apache.apex.shaded.ning19.org.jboss.netty.channel.Channel;
import org.apache.apex.shaded.ning19.org.jboss.netty.channel.ChannelFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyInputStreamBody
implements NettyBody {
    private static final Logger LOGGER = LoggerFactory.getLogger(NettyInputStreamBody.class);
    private final InputStream inputStream;

    public NettyInputStreamBody(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    @Override
    public long getContentLength() {
        return -1L;
    }

    @Override
    public String getContentType() {
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void write(Channel channel, NettyResponseFuture<?> future, AsyncHttpClientConfig config) throws IOException {
        InputStream is = this.inputStream;
        if (future.isStreamWasAlreadyConsumed()) {
            if (!is.markSupported()) {
                LOGGER.warn("Stream has already been consumed and cannot be reset");
                return;
            }
            is.reset();
        } else {
            future.setStreamWasAlreadyConsumed(true);
        }
        InputStreamBodyGenerator generator = new InputStreamBodyGenerator(is);
        generator.patchNettyChunkingIssue(true);
        final Body body = generator.createBody();
        channel.write(new BodyChunkedInput(body)).addListener(new ProgressListener(config, future.getAsyncHandler(), future, false){

            @Override
            public void operationComplete(ChannelFuture cf) {
                MiscUtils.closeSilently(body);
                super.operationComplete(cf);
            }
        });
    }
}

