/*
 * Decompiled with CFR 0.152.
 */
package org.apache.apex.shaded.ning19.com.ning.http.client.resumable;

import java.io.File;
import java.io.FileOutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Scanner;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.apex.shaded.ning19.com.ning.http.client.resumable.ResumableAsyncHandler;
import org.apache.apex.shaded.ning19.com.ning.http.util.MiscUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertiesBasedResumableProcessor
implements ResumableAsyncHandler.ResumableProcessor {
    private static final Logger log = LoggerFactory.getLogger(PropertiesBasedResumableProcessor.class);
    private static final File TMP = new File(System.getProperty("java.io.tmpdir"), "ahc");
    private static final String storeName = "ResumableAsyncHandler.properties";
    private final ConcurrentHashMap<String, Long> properties = new ConcurrentHashMap();

    @Override
    public void put(String url, long transferredBytes) {
        this.properties.put(url, transferredBytes);
    }

    @Override
    public void remove(String uri) {
        if (uri != null) {
            this.properties.remove(uri);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void save(Map<String, Long> map) {
        log.debug("Saving current download state {}", (Object)this.properties.toString());
        FileOutputStream os = null;
        try {
            if (!TMP.exists() && !TMP.mkdirs()) {
                throw new IllegalStateException("Unable to create directory: " + TMP.getAbsolutePath());
            }
            File f = new File(TMP, storeName);
            if (!f.exists() && !f.createNewFile()) {
                throw new IllegalStateException("Unable to create temp file: " + f.getAbsolutePath());
            }
            if (!f.canWrite()) {
                throw new IllegalStateException();
            }
            os = new FileOutputStream(f);
            for (Map.Entry<String, Long> e : this.properties.entrySet()) {
                os.write(PropertiesBasedResumableProcessor.append(e).getBytes(StandardCharsets.UTF_8));
            }
            os.flush();
            if (os == null) return;
        }
        catch (Throwable e) {
            try {
                log.warn(e.getMessage(), e);
                return;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                if (os != null) {
                    MiscUtils.closeSilently(os);
                }
            }
        }
        MiscUtils.closeSilently(os);
        return;
    }

    private static String append(Map.Entry<String, Long> e) {
        return e.getKey() + '=' + e.getValue() + '\n';
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Long> load() {
        try (Scanner scan = null;){
            scan = new Scanner(new File(TMP, storeName), StandardCharsets.UTF_8.name());
            scan.useDelimiter("[=\n]");
            while (scan.hasNext()) {
                String key = scan.next().trim();
                String value = scan.next().trim();
                this.properties.put(key, Long.valueOf(value));
            }
            log.debug("Loading previous download state {}", (Object)this.properties.toString());
        }
        return this.properties;
    }
}

