/*
 * Decompiled with CFR 0.152.
 */
package org.apache.apex.shaded.ning19.org.jboss.netty.handler.codec.socks;

import java.nio.charset.CharsetEncoder;
import org.apache.apex.shaded.ning19.org.jboss.netty.buffer.ChannelBuffer;
import org.apache.apex.shaded.ning19.org.jboss.netty.handler.codec.socks.SocksMessage;
import org.apache.apex.shaded.ning19.org.jboss.netty.handler.codec.socks.SocksRequest;
import org.apache.apex.shaded.ning19.org.jboss.netty.util.CharsetUtil;

public final class SocksAuthRequest
extends SocksRequest {
    private static final CharsetEncoder asciiEncoder = CharsetUtil.getEncoder(CharsetUtil.US_ASCII);
    private static final SocksMessage.SubnegotiationVersion SUBNEGOTIATION_VERSION = SocksMessage.SubnegotiationVersion.AUTH_PASSWORD;
    private final String username;
    private final String password;

    public SocksAuthRequest(String username, String password) {
        super(SocksRequest.SocksRequestType.AUTH);
        if (username == null) {
            throw new NullPointerException("username");
        }
        if (password == null) {
            throw new NullPointerException("password");
        }
        if (!asciiEncoder.canEncode(username) || !asciiEncoder.canEncode(password)) {
            throw new IllegalArgumentException("username: " + username + " or password: **** values should be in pure ascii");
        }
        if (username.length() > 255) {
            throw new IllegalArgumentException("username: " + username + " exceeds 255 char limit");
        }
        if (password.length() > 255) {
            throw new IllegalArgumentException("password: **** exceeds 255 char limit");
        }
        this.username = username;
        this.password = password;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public void encodeAsByteBuf(ChannelBuffer channelBuffer) throws Exception {
        channelBuffer.writeByte(SUBNEGOTIATION_VERSION.getByteValue());
        channelBuffer.writeByte(this.username.length());
        channelBuffer.writeBytes(this.username.getBytes("US-ASCII"));
        channelBuffer.writeByte(this.password.length());
        channelBuffer.writeBytes(this.password.getBytes("US-ASCII"));
    }
}

