/*
 * Decompiled with CFR 0.152.
 */
package com.sun.script.jaskell;

import com.sun.script.jaskell.JaskellScriptEngine;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JaskellScriptEngineFactory
implements ScriptEngineFactory {
    private static List<String> names = new ArrayList<String>(1);
    private static List<String> extensions;
    private static List<String> mimeTypes;

    @Override
    public String getEngineName() {
        return "jaskell";
    }

    @Override
    public String getEngineVersion() {
        return "1.0";
    }

    @Override
    public String getLanguageName() {
        return "jaskell";
    }

    @Override
    public String getLanguageVersion() {
        return "1.0";
    }

    @Override
    public List<String> getExtensions() {
        return extensions;
    }

    @Override
    public List<String> getMimeTypes() {
        return mimeTypes;
    }

    @Override
    public List<String> getNames() {
        return names;
    }

    @Override
    public Object getParameter(String key) {
        if (key.equals("javax.script.engine")) {
            return this.getEngineName();
        }
        if (key.equals("javax.script.engine_version")) {
            return this.getEngineVersion();
        }
        if (key.equals("javax.script.language")) {
            return this.getLanguageName();
        }
        if (key.equals("javax.script.language_version")) {
            return this.getLanguageVersion();
        }
        if (key.equals("THREADING")) {
            return "MULTITHREADED";
        }
        throw new IllegalArgumentException("Invalid key");
    }

    @Override
    public ScriptEngine getScriptEngine() {
        return new JaskellScriptEngine(this);
    }

    public String getMethodCallSyntax(String obj, String method, String ... args) {
        String ret = new StringBuffer().append(obj).append(".").append(method).append(" [").toString();
        int len = args.length;
        if (len == 0) {
            ret = new StringBuffer().append(ret).append("]").toString();
            return ret;
        }
        for (int i = 0; i < len; ++i) {
            ret = new StringBuffer().append(ret).append(args[i]).toString();
            ret = i != len - 1 ? new StringBuffer().append(ret).append(", ").toString() : new StringBuffer().append(ret).append("]").toString();
        }
        return ret;
    }

    @Override
    public String getOutputStatement(String toDisplay) {
        StringBuffer buf = new StringBuffer();
        buf.append("print(\"");
        int len = toDisplay.length();
        block4: for (int i = 0; i < len; ++i) {
            char ch = toDisplay.charAt(i);
            switch (ch) {
                case '\"': {
                    buf.append("\\\"");
                    continue block4;
                }
                case '\\': {
                    buf.append("\\\\");
                    continue block4;
                }
                default: {
                    buf.append(ch);
                }
            }
        }
        buf.append("\")");
        return buf.toString();
    }

    @Override
    public String getProgram(String ... statements) {
        StringBuffer ret = new StringBuffer();
        int len = statements.length;
        ret.append("let ");
        for (int i = 0; i < len; ++i) {
            ret.append(statements[i]);
            ret.append(";\n");
        }
        ret.append(" end");
        return ret.toString();
    }

    static {
        names.add("jaskell");
        names = Collections.unmodifiableList(names);
        extensions = new ArrayList<String>(2);
        extensions.add("jaskell");
        extensions.add("jsl");
        extensions = Collections.unmodifiableList(extensions);
        mimeTypes = new ArrayList<String>(0);
        mimeTypes = Collections.unmodifiableList(mimeTypes);
    }
}

