/*
 * Decompiled with CFR 0.152.
 */
package javax.script;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.SimpleBindings;
import sun.misc.Service;

public class ScriptEngineManager {
    protected HashSet engineSpis = new HashSet();
    protected HashMap nameAssociations = new HashMap();
    protected HashMap extensionAssocitions = new HashMap();
    protected HashMap mimeTypeAssociations = new HashMap();
    protected Bindings globalscope = new SimpleBindings();

    public ScriptEngineManager() {
        Iterator iterator = Service.providers((Class)ScriptEngineFactory.class);
        while (iterator.hasNext()) {
            int i;
            ScriptEngineFactory factory;
            try {
                factory = (ScriptEngineFactory)iterator.next();
            }
            catch (Throwable e) {
                continue;
            }
            this.engineSpis.add(factory);
            List data = factory.getNames();
            for (i = 0; i < data.size(); ++i) {
                this.nameAssociations.put(data.get(i), factory);
            }
            data = factory.getExtensions();
            for (i = 0; i < data.size(); ++i) {
                this.extensionAssocitions.put(data.get(i), factory);
            }
            data = factory.getMimeTypes();
            for (i = 0; i < data.size(); ++i) {
                this.mimeTypeAssociations.put(data.get(i), factory);
            }
        }
    }

    public Object get(String key) {
        return this.globalscope.get(key);
    }

    public ScriptEngine getEngineByExtension(String extension) {
        ScriptEngine engine = null;
        ScriptEngineFactory factory = (ScriptEngineFactory)this.extensionAssocitions.get(extension);
        if (factory != null) {
            engine = factory.getScriptEngine();
            engine.setBindings(this.globalscope, 200);
        }
        return engine;
    }

    public ScriptEngine getEngineByMimeType(String mimeType) {
        ScriptEngine engine = null;
        ScriptEngineFactory factory = (ScriptEngineFactory)this.mimeTypeAssociations.get(mimeType);
        if (factory != null) {
            engine = factory.getScriptEngine();
            engine.setBindings(this.globalscope, 200);
        }
        return engine;
    }

    public ScriptEngine getEngineByName(String name) {
        ScriptEngine engine = null;
        ScriptEngineFactory factory = (ScriptEngineFactory)this.nameAssociations.get(name);
        if (factory != null) {
            engine = factory.getScriptEngine();
            engine.setBindings(this.globalscope, 200);
        }
        return engine;
    }

    public ScriptEngineFactory[] getEngineFactories() {
        ArrayList factories = new ArrayList();
        Iterator iter = this.engineSpis.iterator();
        while (iter.hasNext()) {
            factories.add(iter.next());
        }
        return factories.toArray(new ScriptEngineFactory[factories.size()]);
    }

    public Bindings getNamespace() {
        return this.globalscope;
    }

    public void put(String key, Object value) {
        this.globalscope.put(key, value);
    }

    public void registerEngineExtension(String extension, Class factory) {
        this.extensionAssocitions.put(extension, factory);
    }

    public void registerEngineName(String name, Class factory) {
        this.nameAssociations.put(name, factory);
    }

    public void registerEngineMimeType(String mimeType, Class factory) {
        this.mimeTypeAssociations.put(mimeType, factory);
    }

    public void setNamespace(Bindings namespace) {
        this.globalscope = namespace;
    }
}

