/*
 * Decompiled with CFR 0.152.
 */
package javax.script;

import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Arrays;
import java.util.List;
import javax.script.Bindings;
import javax.script.ScriptContext;
import javax.script.SimpleBindings;

public class SimpleScriptContext
implements ScriptContext {
    protected Bindings globalScope = new SimpleBindings();
    protected Bindings engineScope = new SimpleBindings();
    private Reader reader = new InputStreamReader(System.in);
    private Writer writer = new PrintWriter(System.out, true);
    private Writer errorWriter = new PrintWriter(System.err, true);
    private static final List SCOPES = Arrays.asList(100, 200);

    public Object getAttribute(String name) throws IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        if (this.engineScope.get(name) != null) {
            return this.engineScope.get(name);
        }
        if (this.globalScope.get(name) != null) {
            return this.globalScope.get(name);
        }
        return null;
    }

    public Object getAttribute(String name, int scope) throws IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        switch (scope) {
            case 100: {
                return this.engineScope.get(name);
            }
            case 200: {
                return this.globalScope.get(name);
            }
        }
        throw new IllegalArgumentException("invalid scope");
    }

    public int getAttributesScope(String name) {
        if (this.engineScope.containsKey(name)) {
            return 100;
        }
        if (this.globalScope.containsKey(name)) {
            return 200;
        }
        return -1;
    }

    public Bindings getBindings(int scope) {
        switch (scope) {
            case 100: {
                return this.engineScope;
            }
            case 200: {
                return this.globalScope;
            }
        }
        return null;
    }

    public Object removeAttribute(String name, int scope) throws IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        switch (scope) {
            case 100: {
                return this.engineScope.remove(name);
            }
            case 200: {
                return this.globalScope.remove(name);
            }
        }
        throw new IllegalArgumentException("invalid scope");
    }

    public void setAttribute(String name, Object value, int scope) throws IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        switch (scope) {
            case 100: {
                this.engineScope.put(name, value);
                break;
            }
            case 200: {
                this.globalScope.put(name, value);
                break;
            }
            default: {
                throw new IllegalArgumentException("invaild scope");
            }
        }
    }

    public void setBindings(Bindings namespace, int scope) throws IllegalArgumentException {
        switch (scope) {
            case 100: {
                this.engineScope = namespace;
                break;
            }
            case 200: {
                this.globalScope = namespace;
                break;
            }
            default: {
                throw new IllegalArgumentException("invaild scope");
            }
        }
    }

    public List getScopes() {
        return SCOPES;
    }

    public Reader getReader() {
        return this.reader;
    }

    public void setReader(Reader reader) {
        this.reader = reader;
    }

    public Writer getWriter() {
        return this.writer;
    }

    public void setWriter(Writer writer) {
        this.writer = writer;
    }

    public Writer getErrorWriter() {
        return this.errorWriter;
    }

    public void setErrorWriter(Writer writer) {
        this.errorWriter = writer;
    }
}

