/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.engine;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Pattern;
import org.apache.camel.CamelContext;
import org.apache.camel.LoggingLevel;
import org.apache.camel.TypeConverter;
import org.apache.camel.spi.BeanIntrospection;
import org.apache.camel.spi.CamelLogger;
import org.apache.camel.support.IntrospectionSupport;
import org.apache.camel.support.service.ServiceSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultBeanIntrospection
extends ServiceSupport
implements BeanIntrospection {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultBeanIntrospection.class);
    private static final Pattern SECRETS = Pattern.compile(".*(passphrase|password|secretKey).*", 2);
    private final AtomicLong invoked = new AtomicLong();
    private volatile boolean extendedStatistics;
    private LoggingLevel loggingLevel = LoggingLevel.TRACE;
    private CamelLogger logger = new CamelLogger(LOG, this.loggingLevel);

    public long getInvokedCounter() {
        return this.invoked.get();
    }

    public void resetCounters() {
        this.invoked.set(0L);
    }

    public boolean isExtendedStatistics() {
        return this.extendedStatistics;
    }

    public void setExtendedStatistics(boolean extendedStatistics) {
        this.extendedStatistics = extendedStatistics;
    }

    public LoggingLevel getLoggingLevel() {
        return this.loggingLevel;
    }

    public void setLoggingLevel(LoggingLevel loggingLevel) {
        this.loggingLevel = loggingLevel;
        this.logger = new CamelLogger(LOG, loggingLevel);
    }

    private void log(String method, Object target, Object ... args) {
        Object obj = "null";
        if (args != null && args.length > 0) {
            obj = Arrays.asList(args);
        }
        if (target == null) {
            this.logger.log("Invoked: " + this.invoked.get() + " times (overall) [Method: " + method + "]");
        } else if (args == null) {
            this.logger.log("Invoked: " + this.invoked.get() + " times (overall) [Method: " + method + ", Target: " + target + "]");
        } else {
            this.logger.log("Invoked: " + this.invoked.get() + " times (overall) [Method: " + method + ", Target: " + target + ", Arguments: " + obj + "]");
        }
    }

    public BeanIntrospection.ClassInfo cacheClass(Class<?> clazz) {
        if (this.logger.shouldLog()) {
            this.log("cacheClass", clazz, new Object[0]);
        }
        this.invoked.incrementAndGet();
        return IntrospectionSupport.cacheClass(clazz);
    }

    public void clearCache() {
        if (this.logger.shouldLog()) {
            this.log("clearCache", null, new Object[0]);
        }
        IntrospectionSupport.clearCache();
    }

    public long getCachedClassesCounter() {
        return IntrospectionSupport.getCacheCounter();
    }

    public boolean getProperties(Object target, Map<String, Object> properties, String optionPrefix) {
        this.invoked.incrementAndGet();
        if (this.logger.shouldLog()) {
            this.log("getProperties", target, new Object[0]);
        }
        return IntrospectionSupport.getProperties((Object)target, properties, (String)optionPrefix);
    }

    public boolean getProperties(Object target, Map<String, Object> properties, String optionPrefix, boolean includeNull) {
        this.invoked.incrementAndGet();
        if (this.logger.shouldLog()) {
            this.log("getProperties", target, new Object[0]);
        }
        return IntrospectionSupport.getProperties((Object)target, properties, (String)optionPrefix, (boolean)includeNull);
    }

    public Object getOrElseProperty(Object target, String propertyName, Object defaultValue, boolean ignoreCase) {
        this.invoked.incrementAndGet();
        if (this.logger.shouldLog()) {
            this.log("getOrElseProperty", target, propertyName);
        }
        return IntrospectionSupport.getOrElseProperty((Object)target, (String)propertyName, (Object)defaultValue, (boolean)ignoreCase);
    }

    public Method getPropertyGetter(Class<?> type, String propertyName, boolean ignoreCase) throws NoSuchMethodException {
        this.invoked.incrementAndGet();
        if (this.logger.shouldLog()) {
            this.log("getPropertyGetter", type, propertyName);
        }
        return IntrospectionSupport.getPropertyGetter(type, (String)propertyName, (boolean)ignoreCase);
    }

    public boolean setProperty(CamelContext context, TypeConverter typeConverter, Object target, String name, Object value, String refName, boolean allowBuilderPattern, boolean allowPrivateSetter, boolean ignoreCase) throws Exception {
        this.invoked.incrementAndGet();
        if (this.logger.shouldLog()) {
            Object text = value;
            if (SECRETS.matcher(name).find()) {
                text = "xxxxxx";
            }
            this.log("setProperty", target, name, text);
        }
        return IntrospectionSupport.setProperty((CamelContext)context, (TypeConverter)typeConverter, (Object)target, (String)name, (Object)value, (String)refName, (boolean)allowBuilderPattern, (boolean)allowPrivateSetter, (boolean)ignoreCase);
    }

    public boolean setProperty(CamelContext context, Object target, String name, Object value) throws Exception {
        this.invoked.incrementAndGet();
        if (this.logger.shouldLog()) {
            Object text = value;
            if (SECRETS.matcher(name).find()) {
                text = "xxxxxx";
            }
            this.log("setProperty", target, name, text);
        }
        return IntrospectionSupport.setProperty((CamelContext)context, (Object)target, (String)name, (Object)value);
    }

    public Set<Method> findSetterMethods(Class<?> clazz, String name, boolean allowBuilderPattern, boolean allowPrivateSetter, boolean ignoreCase) {
        this.invoked.incrementAndGet();
        if (this.logger.shouldLog()) {
            this.log("findSetterMethods", clazz, new Object[0]);
        }
        return IntrospectionSupport.findSetterMethods(clazz, (String)name, (boolean)allowBuilderPattern, (boolean)allowPrivateSetter, (boolean)ignoreCase);
    }

    protected void doStart() throws Exception {
    }

    protected void doStop() throws Exception {
        IntrospectionSupport.stop();
        if (this.extendedStatistics) {
            LOG.info("BeanIntrospection invoked: {} times", (Object)this.getInvokedCounter());
        } else {
            LOG.debug("BeanIntrospection invoked: {} times", (Object)this.getInvokedCounter());
        }
    }
}

