/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.el.impl;

import java.util.Map;
import org.apache.cocoon.el.Expression;
import org.apache.cocoon.el.ExpressionCompiler;
import org.apache.cocoon.el.ExpressionException;
import org.apache.cocoon.el.ExpressionFactory;

public class DefaultExpressionFactory
implements ExpressionFactory {
    public static final String DEFAULT_EXPRESSION_LANGUAGE = "default";
    protected Map expressionCompilers;

    public Expression getExpression(String language, String expression) throws ExpressionException {
        if (!this.expressionCompilers.containsKey(language)) {
            throw new ExpressionException("Can't find a compiler for " + language);
        }
        ExpressionCompiler compiler = (ExpressionCompiler)this.expressionCompilers.get(language);
        return compiler.compile(language, expression);
    }

    public Expression getExpression(String expression) throws ExpressionException {
        String language = DEFAULT_EXPRESSION_LANGUAGE;
        int end = expression.indexOf(58);
        if (end != -1) {
            language = expression.substring(0, end);
            expression = expression.substring(end + 1);
        }
        return this.getExpression(language, expression);
    }

    public Map getExpressionCompilers() {
        return this.expressionCompilers;
    }

    public void setExpressionCompilers(Map expressionCompilers) {
        this.expressionCompilers = expressionCompilers;
    }
}

