/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.el.impl.objectmodel;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.cocoon.el.impl.objectmodel.UnmodifiableMultiMap;
import org.apache.cocoon.el.objectmodel.ObjectModel;
import org.apache.cocoon.el.objectmodel.ObjectModelProvider;
import org.apache.commons.collections.ArrayStack;
import org.apache.commons.collections.KeyValue;
import org.apache.commons.collections.MultiMap;
import org.apache.commons.collections.iterators.ReverseListIterator;
import org.apache.commons.collections.keyvalue.DefaultKeyValue;
import org.apache.commons.collections.map.AbstractMapDecorator;
import org.apache.commons.collections.map.MultiValueMap;
import org.apache.commons.jxpath.DynamicPropertyHandler;
import org.apache.commons.jxpath.JXPathBeanInfo;
import org.apache.commons.jxpath.JXPathIntrospector;

public class ObjectModelImpl
extends AbstractMapDecorator
implements ObjectModel {
    private static final String SEGMENT_SEPARATOR = "/";
    private ArrayStack localContexts;
    private Map singleValueMap = new HashMap();
    private MultiMap multiValueMap;
    private MultiMap multiValueMapForLocated;
    private Map initialEntries;
    private boolean modified;

    public ObjectModelImpl() {
        this.map = this.singleValueMap;
        this.localContexts = new ArrayStack();
        this.multiValueMap = MultiValueMap.decorate(new HashMap(), (Class)StackReversedIteration.class);
        this.multiValueMapForLocated = MultiValueMap.decorate(new HashMap(), (Class)StackReversedIteration.class);
    }

    public Object get(Object key) {
        if ("this".equals(key)) {
            return this;
        }
        return super.get(key);
    }

    public MultiMap getAll() {
        return UnmodifiableMultiMap.decorate(this.multiValueMap);
    }

    public Object put(Object key, Object value) {
        this.modified = true;
        if (!this.localContexts.empty()) {
            ((ArrayStack)this.localContexts.peek()).push((Object)new DefaultKeyValue(key, value));
        }
        this.singleValueMap.put(key, value);
        this.multiValueMap.put(key, value);
        return value;
    }

    public void putAll(Map mapToCopy) {
        this.modified = true;
        if (!this.localContexts.empty()) {
            ArrayStack entries = (ArrayStack)this.localContexts.peek();
            Iterator keysIterator = mapToCopy.keySet().iterator();
            while (keysIterator.hasNext()) {
                Object key = keysIterator.next();
                entries.push((Object)new DefaultKeyValue(key, mapToCopy.get(key)));
            }
        }
        this.singleValueMap.putAll(mapToCopy);
        this.multiValueMap.putAll(mapToCopy);
    }

    private Map locateMapAt(String path, boolean createIfNeeded) {
        if (path.lastIndexOf(SEGMENT_SEPARATOR) == -1) {
            return this;
        }
        Object map = this;
        int segmentBegin = 0;
        int segmentEnd = path.indexOf(SEGMENT_SEPARATOR);
        while (segmentEnd != -1) {
            String key = path.substring(segmentBegin, segmentEnd);
            if (map.containsKey(key)) {
                Object obj = map.get(key);
                if (!(obj instanceof Map)) {
                    throw new ClassCastException("Object at path " + path.substring(0, segmentEnd) + "is not a Map");
                }
                map = (Map)obj;
            } else {
                if (!createIfNeeded) {
                    return null;
                }
                HashMap newMap = new HashMap();
                map.put(key, newMap);
                map = newMap;
            }
            segmentBegin = segmentEnd + 1;
            segmentEnd = path.indexOf(SEGMENT_SEPARATOR, segmentBegin);
        }
        return map;
    }

    public void putAt(String path, Object value) {
        if (path == null) {
            throw new NullPointerException("Path cannot be null.");
        }
        if (path.length() == 0) {
            throw new IllegalArgumentException("Path cannot be empty");
        }
        Map map = this.locateMapAt(path, true);
        String key = path.substring(path.lastIndexOf(SEGMENT_SEPARATOR) + 1, path.length());
        if (!this.localContexts.empty()) {
            ((ArrayStack)this.localContexts.peek()).push((Object)new PathValue(path, value));
        }
        map.put(key, value);
    }

    private void removeAt(String path, Object value) {
        if (path == null) {
            throw new NullPointerException("Path cannot be null.");
        }
        if (path.length() == 0) {
            throw new IllegalArgumentException("Path cannot be empty");
        }
        Map map = this.locateMapAt(path, false);
        String key = path.substring(path.lastIndexOf(SEGMENT_SEPARATOR) + 1, path.length());
        if (map == null) {
            return;
        }
        this.multiValueMapForLocated.remove((Object)key, value);
        if (this.multiValueMap.containsKey((Object)key)) {
            map.put(key, ((StackReversedIteration)((Object)this.multiValueMap.get((Object)key))).peek());
        } else {
            map.remove(key);
        }
    }

    public void cleanupLocalContext() {
        if (this.localContexts.empty()) {
            throw new IllegalStateException("Local contexts stack is empty");
        }
        ArrayStack removeEntries = (ArrayStack)this.localContexts.pop();
        while (!removeEntries.isEmpty()) {
            PathValue entry;
            if (removeEntries.peek() instanceof PathValue) {
                entry = (PathValue)removeEntries.pop();
                this.removeAt(entry.getPath(), entry.getValue());
                continue;
            }
            entry = (KeyValue)removeEntries.pop();
            Object key = entry.getKey();
            Object value = entry.getValue();
            this.multiValueMap.remove(key, value);
            if (this.multiValueMap.containsKey(key)) {
                this.singleValueMap.put(key, ((StackReversedIteration)((Object)this.multiValueMap.get(key))).peek());
                continue;
            }
            this.singleValueMap.remove(key);
        }
    }

    public void markLocalContext() {
        this.localContexts.push((Object)new ArrayStack());
    }

    public Map getInitialEntries() {
        return this.initialEntries;
    }

    public void setInitialEntries(Map initialEntries) {
        if (this.initialEntries != null) {
            throw new IllegalStateException("Object Model has initial entries set already.");
        }
        this.initialEntries = initialEntries;
        Iterator keysIterator = initialEntries.keySet().iterator();
        while (keysIterator.hasNext()) {
            Object key = keysIterator.next();
            this.put(key, ((ObjectModelProvider)initialEntries.get(key)).getObject());
        }
        this.modified = false;
    }

    public void fillContext() {
        Object contextObject = this.get("contextBean");
        if (contextObject == null) {
            return;
        }
        JXPathBeanInfo bi = JXPathIntrospector.getBeanInfo(contextObject.getClass());
        if (bi.isDynamic()) {
            Class cl = bi.getDynamicPropertyHandlerClass();
            try {
                DynamicPropertyHandler h = (DynamicPropertyHandler)cl.newInstance();
                String[] result = h.getPropertyNames(contextObject);
                int len = result.length;
                for (int i = 0; i < len; ++i) {
                    try {
                        this.put(result[i], h.getProperty(contextObject, result[i]));
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            PropertyDescriptor[] props = bi.getPropertyDescriptors();
            int len = props.length;
            for (int i = 0; i < len; ++i) {
                try {
                    Method read = props[i].getReadMethod();
                    if (read == null) continue;
                    this.put(props[i].getName(), read.invoke(contextObject, null));
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void setParent(ObjectModel parentObjectModel) {
        if (this.modified) {
            throw new IllegalStateException("Setting parent may occur only if Object Model is empty.");
        }
        this.singleValueMap.putAll(parentObjectModel);
        this.multiValueMap.putAll((Map)parentObjectModel.getAll());
    }

    private final class PathValue {
        private String path;
        private Object value;

        public PathValue(String path, Object value) {
            this.path = path;
            this.value = value;
        }

        public String getPath() {
            return this.path;
        }

        public Object getValue() {
            return this.value;
        }
    }

    public static class StackReversedIteration
    extends ArrayStack {
        public Iterator iterator() {
            return new ReverseListIterator((List)((Object)this));
        }

        public ListIterator listIterator() {
            throw new UnsupportedOperationException();
        }
    }
}

