/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.template.expression;

import java.io.CharArrayReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.Iterator;
import java.util.List;
import org.apache.cocoon.el.objectmodel.ObjectModel;
import org.apache.cocoon.el.parsing.StringTemplateParser;
import org.apache.cocoon.el.parsing.Subst;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class Substitutions {
    private final List substitutions;
    private final boolean hasSubstitutions;

    public Substitutions(StringTemplateParser stringTemplateParser, Locator location, String stringTemplate) throws SAXException {
        this(stringTemplateParser, location, new StringReader(stringTemplate));
    }

    public Substitutions(StringTemplateParser stringTemplateParser, Locator location, char[] chars, int start, int length) throws SAXException {
        this(stringTemplateParser, location, new CharArrayReader(chars, start, length));
    }

    private Substitutions(StringTemplateParser stringTemplateParser, Locator location, Reader in) throws SAXException {
        this.substitutions = stringTemplateParser.parseSubstitutions(in, "", location);
        this.hasSubstitutions = !this.substitutions.isEmpty();
    }

    public boolean hasSubstitutions() {
        return this.hasSubstitutions;
    }

    public Iterator iterator() {
        return this.substitutions.iterator();
    }

    public int size() {
        return this.substitutions.size();
    }

    public Object get(int pos) {
        return this.substitutions.get(pos);
    }

    public String toString(Locator location, ObjectModel objectModel) throws SAXException {
        StringBuffer buf = new StringBuffer();
        Iterator i = this.iterator();
        while (i.hasNext()) {
            Object val;
            Subst subst = (Subst)i.next();
            try {
                val = subst.getValue(objectModel);
            }
            catch (Exception e) {
                throw new SAXParseException(e.getMessage(), location, e);
            }
            if (val == null) continue;
            buf.append(val.toString());
        }
        return buf.toString();
    }
}

