/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.flow.javascript;

import org.apache.cocoon.util.AbstractLogEnabled;
import org.apache.cocoon.util.location.Location;
import org.apache.cocoon.util.location.LocationImpl;
import org.mozilla.javascript.ErrorReporter;
import org.mozilla.javascript.EvaluatorException;
import org.mozilla.javascript.tools.ToolErrorReporter;

public class JSErrorReporter
extends AbstractLogEnabled
implements ErrorReporter {
    private Location location;
    private StringBuffer message;

    private void appendMessage(String text, String sourceName, int line, int column) {
        if (this.location == null) {
            this.location = new LocationImpl(null, sourceName, line, column);
            this.message = new StringBuffer();
        } else {
            this.message.append("\n");
        }
        this.message.append(text);
    }

    public void error(String message, String sourceName, int line, String lineSrc, int column) {
        String errMsg = this.getErrorMessage("msg.error", message, sourceName, line, lineSrc, column);
        this.appendMessage(errMsg, sourceName, line, column);
        System.err.println(errMsg);
        this.getLogger().error((Object)errMsg);
    }

    public void warning(String message, String sourceName, int line, String lineSrc, int column) {
        String errMsg = this.getErrorMessage("msg.warning", message, sourceName, line, lineSrc, column);
        this.appendMessage(errMsg, sourceName, line, column);
        System.err.println(errMsg);
        this.getLogger().warn((Object)errMsg);
    }

    public EvaluatorException runtimeError(String message, String sourceName, int line, String lineSrc, int column) {
        String errMsg = this.getErrorMessage("msg.error", message, sourceName, line, lineSrc, column);
        this.appendMessage(errMsg, sourceName, line, column);
        System.err.println(errMsg);
        return new EvaluatorException(this.message.toString());
    }

    String getErrorMessage(String type, String message, String sourceName, int line, String lineSource, int column) {
        if (line > 0) {
            if (sourceName != null) {
                Object[] errArgs = new Object[]{sourceName, new Integer(line), message};
                return ToolErrorReporter.getMessage((String)"msg.format3", (Object[])errArgs);
            }
            Object[] errArgs = new Object[]{new Integer(line), message};
            return ToolErrorReporter.getMessage((String)"msg.format2", (Object[])errArgs);
        }
        Object[] errArgs = new Object[]{message};
        return ToolErrorReporter.getMessage((String)"msg.format1", (Object[])errArgs);
    }
}

