/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.core.container.spring.pipeline;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.cocoon.components.pipeline.impl.PipelineComponentInfo;
import org.apache.cocoon.core.container.spring.pipeline.PipelineComponentInfoFactoryBean;
import org.apache.cocoon.core.container.spring.pipeline.PipelineComponentInfoInitializer;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.BeanDefinitionDecorator;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class PipelineComponentInfoInitializerDecorator
implements BeanDefinitionDecorator {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];

    public BeanDefinitionHolder decorate(Node source, BeanDefinitionHolder holder, ParserContext ctx) {
        this.registerPipelineComponentInfo(ctx);
        String initializerBeanName = this.registerPipelineComponentInfoInitializer(source, holder, ctx);
        this.createDependencyOnPipelineComponentInfoInitializer(holder, initializerBeanName);
        return holder;
    }

    private void registerPipelineComponentInfo(ParserContext ctx) {
        if (!ctx.getRegistry().containsBeanDefinition(PipelineComponentInfo.ROLE)) {
            BeanDefinitionBuilder defBuilder = BeanDefinitionBuilder.rootBeanDefinition((Class)PipelineComponentInfoFactoryBean.class);
            defBuilder.setSingleton(true);
            defBuilder.setLazyInit(false);
            defBuilder.setInitMethodName("init");
            ctx.getRegistry().registerBeanDefinition(PipelineComponentInfo.ROLE, (BeanDefinition)defBuilder.getBeanDefinition());
        }
    }

    private String registerPipelineComponentInfoInitializer(Node source, BeanDefinitionHolder holder, ParserContext ctx) {
        String componentName = holder.getBeanName();
        String mimeType = ((Element)source).hasAttribute("mime-type") ? ((Element)source).getAttribute("mime-type") : null;
        String label = ((Element)source).hasAttribute("label") ? ((Element)source).getAttribute("label") : null;
        String hint = ((Element)source).hasAttribute("hint") ? ((Element)source).getAttribute("hint") : null;
        BeanDefinitionBuilder initializer = BeanDefinitionBuilder.rootBeanDefinition((Class)PipelineComponentInfoInitializer.class);
        initializer.addPropertyReference("info", PipelineComponentInfo.ROLE);
        initializer.addPropertyValue("componentName", (Object)componentName);
        if (mimeType != null) {
            initializer.addPropertyValue("mimeType", (Object)mimeType);
        }
        if (label != null) {
            initializer.addPropertyValue("label", (Object)label);
        }
        if (hint != null) {
            initializer.addPropertyValue("hint", (Object)hint);
        }
        initializer.setInitMethodName("init");
        String beanName = componentName + "/info";
        ctx.getRegistry().registerBeanDefinition(beanName, (BeanDefinition)initializer.getBeanDefinition());
        return beanName;
    }

    private void createDependencyOnPipelineComponentInfoInitializer(BeanDefinitionHolder holder, String initializerBeanName) {
        AbstractBeanDefinition definition = (AbstractBeanDefinition)holder.getBeanDefinition();
        String[] dependsOn = definition.getDependsOn();
        if (dependsOn == null) {
            dependsOn = new String[]{initializerBeanName};
        } else {
            ArrayList<String> dependencies = new ArrayList<String>(Arrays.asList(dependsOn));
            dependencies.add(initializerBeanName);
            dependsOn = dependencies.toArray(EMPTY_STRING_ARRAY);
        }
        definition.setDependsOn(dependsOn);
    }
}

