/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.servletservice.postable.components;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import org.apache.avalon.framework.parameters.ParameterException;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.components.source.util.SourceUtil;
import org.apache.cocoon.core.xml.SAXParser;
import org.apache.cocoon.servletservice.postable.PostableSource;
import org.apache.cocoon.sitemap.DisposableSitemapComponent;
import org.apache.cocoon.transformation.AbstractSAXTransformer;
import org.apache.commons.io.IOUtils;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceException;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class ServletServiceTransformer
extends AbstractSAXTransformer
implements DisposableSitemapComponent {
    private SAXParser saxParser;
    private PostableSource servletSource;

    public SAXParser getSaxParser() {
        return this.saxParser;
    }

    public void setSaxParser(SAXParser saxParser) {
        this.saxParser = saxParser;
    }

    public void setupTransforming() throws IOException, ProcessingException, SAXException {
        String service;
        super.setupTransforming();
        try {
            service = this.parameters.getParameter("service");
        }
        catch (ParameterException e) {
            throw new ProcessingException((Exception)((Object)e));
        }
        try {
            this.servletSource = (PostableSource)this.resolver.resolveURI(service);
        }
        catch (ClassCastException e) {
            throw new ProcessingException("Resolved '" + service + "' to source that is not postable. Use servlet: protocol for service calls.");
        }
        catch (SourceException se) {
            throw SourceUtil.handle((String)("Error during resolving of '" + service + "'."), (SourceException)se);
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)("Source " + service + " resolved to " + this.servletSource.getURI()));
        }
        this.startSerializedXMLRecording(null);
    }

    public void endDocument() throws SAXException {
        super.endDocument();
        try {
            String xml = this.endSerializedXMLRecording();
            IOUtils.copy((Reader)new StringReader(xml), (OutputStream)this.servletSource.getOutputStream(), (String)"UTF-8");
            SourceUtil.parse((SAXParser)this.saxParser, (Source)this.servletSource, (ContentHandler)this.contentHandler);
        }
        catch (Exception e) {
            throw new SAXException("Exception occured while calling servlet service", e);
        }
    }

    public void dispose() {
        if (this.servletSource != null) {
            this.resolver.release((Source)this.servletSource);
        }
        super.dispose();
    }
}

