/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.treeprocessor.sitemap;

import java.util.Map;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.components.pipeline.ProcessingPipeline;
import org.apache.cocoon.components.treeprocessor.InvokeContext;
import org.apache.cocoon.components.treeprocessor.ParameterizableProcessingNode;
import org.apache.cocoon.components.treeprocessor.PipelineEventComponentProcessingNode;
import org.apache.cocoon.components.treeprocessor.ProcessingNode;
import org.apache.cocoon.components.treeprocessor.variables.VariableResolver;
import org.apache.cocoon.environment.Environment;
import org.apache.cocoon.sitemap.ExecutionContext;
import org.apache.cocoon.sitemap.SitemapExecutor;

public class TransformNode
extends PipelineEventComponentProcessingNode
implements ParameterizableProcessingNode {
    private String transformerName;
    private VariableResolver source;
    private Map parameters;

    public TransformNode(String name, VariableResolver source) {
        this.transformerName = name;
        this.source = source;
    }

    public void setParameters(Map parameterMap) {
        this.parameters = parameterMap;
    }

    public final boolean invoke(Environment env, InvokeContext context) throws Exception {
        Map objectModel = env.getObjectModel();
        ProcessingPipeline pipeline = context.getProcessingPipeline();
        SitemapExecutor.PipelineComponentDescription desc = new SitemapExecutor.PipelineComponentDescription();
        desc.type = this.transformerName;
        desc.source = this.source.resolve(context, objectModel);
        desc.parameters = VariableResolver.buildParameters(this.parameters, context, objectModel);
        desc.hintParameters = this.pipelineHints == null ? Parameters.EMPTY_PARAMETERS : VariableResolver.buildParameters(this.pipelineHints, context, objectModel);
        desc = this.executor.addTransformer((ExecutionContext)this, objectModel, desc);
        pipeline.addTransformer(desc.type, desc.source, desc.parameters, desc.hintParameters);
        if (this.views != null) {
            ProcessingNode viewNode;
            pipeline.informBranchPoint();
            String cocoonView = env.getView();
            if (cocoonView != null && (viewNode = (ProcessingNode)this.views.get(cocoonView)) != null) {
                if (this.getLogger().isInfoEnabled()) {
                    this.getLogger().info((Object)("Jumping to view " + cocoonView + " from transformer at " + this.getLocation()));
                }
                return viewNode.invoke(env, context);
            }
        }
        return false;
    }
}

