/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.treeprocessor.variables;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.components.modules.input.InputModule;
import org.apache.cocoon.components.treeprocessor.InvokeContext;
import org.apache.cocoon.components.treeprocessor.variables.VariableExpressionTokenizer;
import org.apache.cocoon.components.treeprocessor.variables.VariableResolver;
import org.apache.cocoon.el.Expression;
import org.apache.cocoon.el.ExpressionException;
import org.apache.cocoon.el.ExpressionFactory;
import org.apache.cocoon.el.objectmodel.ObjectModel;
import org.apache.cocoon.sitemap.PatternException;

public final class PreparedVariableResolver
extends VariableResolver
implements Disposable {
    private static final int ROOT_SITEMAP_VARIABLE = 0;
    private static final int ANCHOR_VAR = -1;
    private static final int OPEN = -2;
    private static final int CLOSE = -3;
    private static final int COLON = -4;
    private static final int TEXT = -5;
    private static final int EXPR = -7;
    private static final int SITEMAP_VAR = -9;
    private static final int THREADSAFE_MODULE = -10;
    private static final int STATEFUL_MODULE = -11;
    protected static final Token COLON_TOKEN = new Token(-4);
    protected static final Token OPEN_TOKEN = new Token(-2);
    protected static final Token CLOSE_TOKEN = new Token(-3);
    protected static final Token EMPTY_TOKEN = new Token(-7);
    private ServiceManager manager;
    protected List tokens;
    protected boolean needsMapStack;

    public PreparedVariableResolver() {
    }

    public PreparedVariableResolver(String expression, ServiceManager manager) throws PatternException {
        this.setManager(manager);
        this.setExpression(expression);
    }

    public ServiceManager getManager() {
        return this.manager;
    }

    public void setManager(ServiceManager manager) {
        this.manager = manager;
    }

    public void setExpression(String expr) throws PatternException {
        this.originalExpr = expr;
        this.tokens = new ArrayList();
        VariableExpressionTokenizer.tokenize(expr, new VariableExpressionTokenizer.TokenReciever(){

            public void addToken(int type, String value) throws PatternException {
                switch (type) {
                    case -4: {
                        PreparedVariableResolver.this.tokens.add(COLON_TOKEN);
                        break;
                    }
                    case -2: {
                        PreparedVariableResolver.this.tokens.add(OPEN_TOKEN);
                        break;
                    }
                    case -3: {
                        PreparedVariableResolver.this.tokens.add(CLOSE_TOKEN);
                        break;
                    }
                    case -5: {
                        PreparedVariableResolver.this.tokens.add(new Token(value));
                        break;
                    }
                    case -12: {
                        PreparedVariableResolver.this.tokens.add(new Token(-12, value));
                        break;
                    }
                    case -6: {
                        Token token;
                        if (value.equals("sitemap")) {
                            PreparedVariableResolver.this.needsMapStack = true;
                            token = new Token(-9);
                        } else if (value.startsWith("#")) {
                            PreparedVariableResolver.this.needsMapStack = true;
                            token = new Token(-1, value.substring(1));
                        } else {
                            token = PreparedVariableResolver.this.getNewModuleToken(value);
                        }
                        PreparedVariableResolver.this.tokens.add(token);
                        break;
                    }
                    case -8: {
                        PreparedVariableResolver.this.needsMapStack = true;
                        PreparedVariableResolver.this.tokens.add(PreparedVariableResolver.this.getNewVariableToken(value));
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown token type: " + type);
                    }
                }
            }
        });
    }

    protected Token getNewVariableToken(String variable) {
        if (variable.startsWith("/")) {
            return new Token(0, variable.substring(1));
        }
        int level = 1;
        int pos = 0;
        while (variable.startsWith("../", pos)) {
            ++level;
            pos += "../".length();
        }
        return new Token(level, variable.substring(pos));
    }

    protected Token getNewModuleToken(String moduleName) throws PatternException {
        Token token;
        InputModule module;
        try {
            module = (InputModule)this.manager.lookup(InputModule.ROLE + '/' + moduleName);
        }
        catch (ServiceException e) {
            throw new PatternException("Cannot get module named '" + moduleName + "' in expression '" + this.originalExpr + "'", (Throwable)e);
        }
        if (module instanceof ThreadSafe) {
            token = new Token(-10, module);
        } else {
            this.manager.release((Object)module);
            token = new Token(-11, moduleName);
        }
        return token;
    }

    /*
     * Unable to fully structure code
     */
    public final String resolve(InvokeContext context, Map objectModel) throws PatternException {
        mapStack = null;
        stackSize = 0;
        if (this.needsMapStack) {
            if (context == null) {
                throw new PatternException("Need an invoke context to resolve " + this);
            }
            mapStack = context.getMapStack();
            stackSize = mapStack.size();
        }
        stack = new Stack<Token>();
        i = this.tokens.iterator();
        block8: while (i.hasNext()) {
            token = (Token)i.next();
            switch (token.getType()) {
                case -5: {
                    if (stack.empty()) {
                        stack.push(new Token(-7, token.getStringValue()));
                        continue block8;
                    }
                    last = (Token)stack.peek();
                    if (last.hasType(-7)) {
                        last.merge(token);
                        continue block8;
                    }
                    stack.push(new Token(-7, token.getStringValue()));
                    continue block8;
                }
                case -3: {
                    expr = (Token)stack.pop();
                    lastButOne = (Token)stack.pop();
                    if (!expr.hasType(-4)) ** GOTO lbl33
                    stack.pop();
                    result = this.processModule(lastButOne, PreparedVariableResolver.EMPTY_TOKEN, objectModel, context, mapStack, stackSize);
                    ** GOTO lbl67
lbl33:
                    // 1 sources

                    if (!lastButOne.hasType(-4)) ** GOTO lbl39
                    module = (Token)stack.pop();
                    stack.pop();
                    result = this.processModule(module, expr, objectModel, context, mapStack, stackSize);
                    ** GOTO lbl67
lbl39:
                    // 1 sources

                    if (!lastButOne.hasType(-12)) ** GOTO lbl66
                    stack.pop();
                    expressionFactory = null;
                    newObjectModel = null;
                    try {
                        expressionFactory = (ExpressionFactory)this.manager.lookup(ExpressionFactory.ROLE);
                        newObjectModel = (ObjectModel)this.manager.lookup(ObjectModel.ROLE);
                        result = this.processNewExpression(lastButOne, expressionFactory, newObjectModel);
                        var16_14 = null;
                        if (expressionFactory == null) ** GOTO lbl53
                    }
                    catch (Throwable var15_16) {
                        var16_14 = null;
                        if (expressionFactory != null) {
                            this.manager.release((Object)expressionFactory);
                        }
                        if (newObjectModel != null) {
                            this.manager.release((Object)newObjectModel);
                        }
                        throw var15_16;
                    }
                    this.manager.release((Object)expressionFactory);
lbl53:
                    // 2 sources

                    if (newObjectModel != null) {
                        this.manager.release((Object)newObjectModel);
                    }
                    ** GOTO lbl67
                    {
                        catch (ServiceException e) {
                            throw new PatternException("Cannot obtain necessary components to evaluate new expression '" + lastButOne.getStringValue() + "' in expression '" + this.originalExpr + "'", (Throwable)e);
                        }
                    }
lbl66:
                    // 1 sources

                    result = this.processVariable(expr, mapStack, stackSize);
lbl67:
                    // 4 sources

                    if (stack.empty()) {
                        stack.push(result);
                        continue block8;
                    }
                    last = (Token)stack.peek();
                    if (last.hasType(-7)) {
                        last.merge(result);
                        continue block8;
                    }
                    stack.push(result);
                    continue block8;
                }
            }
            stack.push(token);
        }
        if (stack.size() != 1) {
            throw new PatternException("Evaluation error in expression: " + this.originalExpr);
        }
        return ((Token)stack.pop()).getStringValue();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Token processModule(Token module, Token expr, Map objectModel, InvokeContext context, List mapStack, int stackSize) throws PatternException {
        Token token;
        int type = module.getType();
        if (type == -1) {
            String string;
            Map levelResult = context.getMapByAnchor(module.getStringValue());
            if (levelResult == null) {
                throw new PatternException("Error while evaluating '" + this.originalExpr + "' : no anchor '" + String.valueOf(module.getStringValue()) + "' found in context");
            }
            Object result = levelResult.get(expr.getStringValue());
            if (result == null) {
                string = "";
                return new Token(-7, string);
            }
            string = result.toString();
            return new Token(-7, string);
        }
        if (type == -10) {
            try {
                String string;
                InputModule im = module.getModule();
                Object result = im.getAttribute(expr.getStringValue(), null, objectModel);
                if (result == null) {
                    string = "";
                    return new Token(-7, string);
                }
                string = result.toString();
                return new Token(-7, string);
            }
            catch (ConfigurationException confEx) {
                throw new PatternException("Cannot get variable '" + expr.getStringValue() + "' in expression '" + this.originalExpr + "'", (Throwable)confEx);
            }
        }
        if (type == -11) {
            Token token2;
            InputModule im = null;
            String moduleName = module.getStringValue();
            try {
                im = (InputModule)this.manager.lookup(InputModule.ROLE + '/' + moduleName);
                Object result = im.getAttribute(expr.getStringValue(), null, objectModel);
                token2 = new Token(-7, result == null ? "" : result.toString());
            }
            catch (ServiceException e) {
                try {
                    throw new PatternException("Cannot get module '" + moduleName + "' in expression '" + this.originalExpr + "'", (Throwable)e);
                    catch (ConfigurationException confEx) {
                        throw new PatternException("Cannot get variable '" + expr.getStringValue() + "' in expression '" + this.originalExpr + "'", (Throwable)confEx);
                    }
                }
                catch (Throwable throwable) {
                    this.manager.release(im);
                    throw throwable;
                }
            }
            this.manager.release((Object)im);
            return token2;
        }
        if (type != -9) throw new PatternException("Unknown token type: " + expr.getType());
        String variable = expr.getStringValue();
        if (variable.startsWith("/")) {
            token = new Token(0, variable.substring(1));
            return this.processVariable(token, mapStack, stackSize);
        }
        int level = 1;
        int pos = 0;
        while (true) {
            if (!variable.startsWith("../", pos)) {
                token = new Token(level, variable.substring(pos));
                return this.processVariable(token, mapStack, stackSize);
            }
            ++level;
            pos += "../".length();
        }
    }

    private Token processVariable(Token expr, List mapStack, int stackSize) throws PatternException {
        int type = expr.getType();
        String value = expr.getStringValue();
        if (type == 0) {
            Object result = ((Map)mapStack.get(0)).get(value);
            return new Token(-7, result == null ? "" : result.toString());
        }
        if (type > stackSize) {
            throw new PatternException("Error while evaluating '" + this.originalExpr + "' : not so many levels");
        }
        Object result = ((Map)mapStack.get(stackSize - type)).get(value);
        return new Token(-7, result == null ? "" : result.toString());
    }

    private Token processNewExpression(Token expr, ExpressionFactory expressionFactory, ObjectModel newObjectModel) throws PatternException {
        Object result;
        try {
            Expression newExpression = expressionFactory.getExpression(expr.getStringValue());
            result = newExpression.evaluate(newObjectModel);
        }
        catch (ExpressionException e) {
            throw new PatternException("Cannot evaluate new expression '" + expr.getStringValue() + "' in expression " + "'" + this.originalExpr + "'", (Throwable)e);
        }
        return new Token(-7, result == null ? "" : result.toString());
    }

    public final void dispose() {
        if (this.manager != null) {
            Iterator i = this.tokens.iterator();
            while (i.hasNext()) {
                Token token = (Token)i.next();
                if (!token.hasType(-10)) continue;
                InputModule im = token.getModule();
                this.manager.release((Object)im);
            }
            this.tokens.clear();
            this.manager = null;
        }
    }

    private static final class Token {
        private Object value;
        private int type;

        public Token(int type) {
            this.value = type == -7 ? "" : null;
            this.type = type;
        }

        public Token(int type, String value) {
            this.value = value;
            this.type = type;
        }

        public Token(int type, InputModule module) {
            this.value = module;
            this.type = type;
        }

        public Token(String value) {
            this.type = -5;
            this.value = value;
        }

        public int getType() {
            return this.type;
        }

        public String getStringValue() {
            if (this.value instanceof String) {
                return (String)this.value;
            }
            return null;
        }

        public boolean hasType(int type) {
            return this.type == type;
        }

        public boolean equals(Object o) {
            if (o instanceof Token) {
                return ((Token)o).hasType(this.type);
            }
            return false;
        }

        public void merge(Token newToken) {
            this.value = this.value + newToken.getStringValue();
        }

        public InputModule getModule() {
            if (this.value instanceof InputModule) {
                return (InputModule)this.value;
            }
            return null;
        }
    }
}

