/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.core.container.spring.avalon;

import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.cocoon.core.container.spring.avalon.BridgeElementParser;
import org.apache.cocoon.core.container.spring.avalon.SitemapElementParser;
import org.apache.cocoon.util.location.Location;
import org.apache.cocoon.util.location.LocationImpl;
import org.apache.cocoon.util.location.LocationUtils;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.NamespaceHandlerSupport;

public class AvalonNamespaceHandler
extends NamespaceHandlerSupport {
    private static final LocationUtils.LocationFinder confLocFinder = new LocationUtils.LocationFinder(){

        public Location getLocation(Object obj, String description) {
            if (obj instanceof Configuration) {
                Configuration config = (Configuration)obj;
                String locString = config.getLocation();
                LocationImpl result = LocationUtils.parse((String)locString);
                if (LocationUtils.isKnown((Location)result)) {
                    StringBuffer desc = new StringBuffer().append('<');
                    try {
                        if (config.getNamespace().startsWith("http://apache.org/cocoon/sitemap/")) {
                            desc.append("map:");
                        }
                    }
                    catch (ConfigurationException e) {
                        // empty catch block
                    }
                    desc.append(config.getName()).append('>');
                    return new LocationImpl(desc.toString(), (Location)result);
                }
                return result;
            }
            return null;
        }
    };

    public void init() {
        this.registerBeanDefinitionParser("bridge", (BeanDefinitionParser)new BridgeElementParser());
        this.registerBeanDefinitionParser("sitemap", (BeanDefinitionParser)new SitemapElementParser());
    }

    static {
        LocationUtils.addFinder((LocationUtils.LocationFinder)confLocFinder);
    }
}

