/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.core.container.spring.avalon;

import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.core.container.spring.avalon.AvalonPoolable;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;

public final class AvalonServiceManager
implements ServiceManager,
BeanFactoryAware {
    protected BeanFactory beanFactory;

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public boolean hasService(String role) {
        return this.beanFactory.containsBean(role);
    }

    public Object lookup(String role) throws ServiceException {
        if (!this.hasService(role)) {
            throw new ServiceException("AvalonServiceManager", "Component with '" + role + "' is not defined in this service manager.");
        }
        try {
            return this.beanFactory.getBean(role);
        }
        catch (BeansException be) {
            throw new ServiceException("AvalonServiceManager", "Exception during lookup of component with '" + role + "'.", (Throwable)be);
        }
    }

    public void release(Object component) {
        if (component instanceof AvalonPoolable) {
            ((AvalonPoolable)component).putBackIntoAvalonPool();
        }
    }
}

