/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.core.container.spring.avalon;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cocoon.core.container.spring.avalon.ComponentInfo;

public class ConfigurationInfo {
    protected String rootLogger;
    private final Map shorthands;
    private final Map currentRoles;
    private final Map allRoles;
    private final Map keyClassNames;
    private final Map components = new HashMap();
    private final List imports = new ArrayList();

    public ConfigurationInfo() {
        this.shorthands = new HashMap();
        this.currentRoles = new HashMap();
        this.keyClassNames = new HashMap();
        this.allRoles = new HashMap();
    }

    public ConfigurationInfo(ConfigurationInfo parent) {
        this.shorthands = new HashMap(parent.shorthands);
        this.currentRoles = new HashMap();
        this.keyClassNames = new HashMap(parent.keyClassNames);
        this.allRoles = new HashMap(parent.allRoles);
    }

    public Map getComponents() {
        return this.components;
    }

    public String getRootLogger() {
        return this.rootLogger;
    }

    public void setRootLogger(String rootLogger) {
        this.rootLogger = rootLogger;
    }

    public void addComponent(ComponentInfo info) {
        this.components.put(info.getRole(), info);
    }

    public Collection getRoles() {
        return this.currentRoles.values();
    }

    public void addRole(String role, ComponentInfo info) {
        this.currentRoles.put(role, info);
        this.allRoles.put(role, info);
    }

    public ComponentInfo getRole(String role) {
        ComponentInfo info = (ComponentInfo)this.currentRoles.get(role);
        if (info == null) {
            info = (ComponentInfo)this.allRoles.get(role);
        }
        return info;
    }

    public void removeRole(String role) {
        this.currentRoles.remove(role);
    }

    public void clearRoles() {
        this.currentRoles.clear();
    }

    public Map getShorthands() {
        return this.shorthands;
    }

    public Map getKeyClassNames() {
        return this.keyClassNames;
    }

    public void addImport(String uri) {
        this.imports.add(uri);
    }

    public List getImports() {
        return this.imports;
    }

    public String getRoleForName(String alias) {
        String value = (String)this.shorthands.get(alias);
        if (value != null) {
            return value;
        }
        return alias;
    }
}

