/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.environment.internal;

import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.Environment;
import org.apache.cocoon.environment.internal.EnvironmentHelper;
import org.apache.cocoon.environment.internal.UnableToPushEnvironmentException;
import org.apache.cocoon.xml.XMLConsumer;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

final class PushEnvironmentChanger
implements XMLConsumer {
    final XMLConsumer consumer;
    final Environment environment;

    PushEnvironmentChanger(XMLConsumer consumer, Environment environment) {
        this.consumer = consumer;
        this.environment = environment;
    }

    private void enterEnvironment() throws SAXException {
        try {
            EnvironmentHelper.enterEnvironment(this.environment);
        }
        catch (ProcessingException e) {
            throw new SAXException("PushEnvironmentChanger: ", (Exception)((Object)e));
        }
    }

    private void leaveEnvironment() {
        EnvironmentHelper.leaveEnvironment();
    }

    public void setDocumentLocator(Locator locator) {
        try {
            this.enterEnvironment();
        }
        catch (SAXException e) {
            throw new UnableToPushEnvironmentException("Unable to push the environment", e);
        }
        this.consumer.setDocumentLocator(locator);
        this.leaveEnvironment();
    }

    public void startDocument() throws SAXException {
        this.enterEnvironment();
        this.consumer.startDocument();
        this.leaveEnvironment();
    }

    public void endDocument() throws SAXException {
        this.enterEnvironment();
        this.consumer.endDocument();
        this.leaveEnvironment();
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.enterEnvironment();
        this.consumer.startPrefixMapping(prefix, uri);
        this.leaveEnvironment();
    }

    public void endPrefixMapping(String prefix) throws SAXException {
        this.enterEnvironment();
        this.consumer.endPrefixMapping(prefix);
        this.leaveEnvironment();
    }

    public void startElement(String uri, String loc, String raw, Attributes a) throws SAXException {
        this.enterEnvironment();
        this.consumer.startElement(uri, loc, raw, a);
        this.leaveEnvironment();
    }

    public void endElement(String uri, String loc, String raw) throws SAXException {
        this.enterEnvironment();
        this.consumer.endElement(uri, loc, raw);
        this.leaveEnvironment();
    }

    public void characters(char[] c, int start, int len) throws SAXException {
        this.enterEnvironment();
        this.consumer.characters(c, start, len);
        this.leaveEnvironment();
    }

    public void ignorableWhitespace(char[] c, int start, int len) throws SAXException {
        this.enterEnvironment();
        this.consumer.ignorableWhitespace(c, start, len);
        this.leaveEnvironment();
    }

    public void processingInstruction(String target, String data) throws SAXException {
        this.enterEnvironment();
        this.consumer.processingInstruction(target, data);
        this.leaveEnvironment();
    }

    public void skippedEntity(String name) throws SAXException {
        this.enterEnvironment();
        this.consumer.skippedEntity(name);
        this.leaveEnvironment();
    }

    public void startDTD(String name, String publicId, String systemId) throws SAXException {
        this.enterEnvironment();
        this.consumer.startDTD(name, publicId, systemId);
        this.leaveEnvironment();
    }

    public void endDTD() throws SAXException {
        this.enterEnvironment();
        this.consumer.endDTD();
        this.leaveEnvironment();
    }

    public void startEntity(String name) throws SAXException {
        this.enterEnvironment();
        this.consumer.startEntity(name);
        this.leaveEnvironment();
    }

    public void endEntity(String name) throws SAXException {
        this.enterEnvironment();
        this.consumer.endEntity(name);
        this.leaveEnvironment();
    }

    public void startCDATA() throws SAXException {
        this.enterEnvironment();
        this.consumer.startCDATA();
        this.leaveEnvironment();
    }

    public void endCDATA() throws SAXException {
        this.enterEnvironment();
        this.consumer.endCDATA();
        this.leaveEnvironment();
    }

    public void comment(char[] ch, int start, int len) throws SAXException {
        this.enterEnvironment();
        this.consumer.comment(ch, start, len);
        this.leaveEnvironment();
    }
}

