/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.selection;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.selection.Selector;
import org.apache.cocoon.util.AbstractLogEnabled;

public abstract class NamedPatternsSelector
extends AbstractLogEnabled
implements Configurable,
ThreadSafe,
Selector {
    private Map strings;

    protected void configure(Configuration conf, String confName, String nameAttr, String valueAttr) throws ConfigurationException {
        Configuration[] confs = conf.getChildren(confName);
        HashMap<String, ArrayList<String>> configMap = new HashMap<String, ArrayList<String>>();
        for (int i = 0; i < confs.length; ++i) {
            String name = confs[i].getAttribute(nameAttr);
            String value = confs[i].getAttribute(valueAttr);
            ArrayList<String> nameList = (ArrayList<String>)configMap.get(name);
            if (nameList == null) {
                nameList = new ArrayList<String>();
                configMap.put(name, nameList);
            }
            nameList.add(value);
        }
        Iterator entries = configMap.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry entry = entries.next();
            List nameList = (List)entry.getValue();
            entry.setValue(nameList.toArray(new String[nameList.size()]));
        }
        this.strings = configMap;
    }

    protected boolean checkPatterns(String expression, String value) {
        if (value == null) {
            this.getLogger().debug((Object)"No value given -- failing.");
            return false;
        }
        String[] patterns = (String[])this.strings.get(expression);
        if (patterns == null) {
            this.getLogger().warn((Object)("No configuration for expression '" + expression + "' -- failing."));
            return false;
        }
        for (int i = 0; i < patterns.length; ++i) {
            if (value.indexOf(patterns[i]) == -1) continue;
            this.getLogger().debug((Object)(expression + " selected value " + value));
            return true;
        }
        return false;
    }
}

