/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider;

import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.provider.AbstractFileName;

public class LayeredFileName
extends AbstractFileName {
    public static final char LAYER_SEPARATOR = '!';
    static final char SCHEME_SEPARATOR = ':';
    private final FileName outerUri;

    public LayeredFileName(String scheme, FileName outerUri, String path, FileType type) {
        super(scheme, path, type);
        this.outerUri = outerUri;
    }

    @Override
    protected void appendRootUri(StringBuilder buffer, boolean addPassword) {
        buffer.append(this.getScheme());
        buffer.append(':');
        buffer.append(this.getOuterName().getURI());
        buffer.append('!');
    }

    @Override
    public FileName createName(String path, FileType type) {
        return new LayeredFileName(this.getScheme(), this.getOuterName(), path, type);
    }

    public FileName getOuterName() {
        return this.outerUri;
    }
}

