/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.maven_plugin.wsdl2java;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.helpers.FileUtils;
import org.apache.cxf.maven_plugin.GenericWsdlOption;
import org.apache.cxf.maven_plugin.WsdlUtilities;
import org.apache.cxf.maven_plugin.wsdl2java.WsdlOption;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;

public final class WsdlOptionLoader {
    private static final String WSDL_OPTIONS = "-options$";
    private static final String WSDL_BINDINGS = "-binding-?\\d*.xml$";

    private WsdlOptionLoader() {
    }

    public static List<GenericWsdlOption> loadWsdlOptionsFromDependencies(MavenProject project, File outputDir) {
        ArrayList<GenericWsdlOption> options = new ArrayList<GenericWsdlOption>();
        Set dependencies = CastUtils.cast((Set)project.getDependencyArtifacts());
        for (Artifact artifact : dependencies) {
            WsdlOption option = WsdlOptionLoader.generateWsdlOptionFromArtifact(artifact, outputDir);
            if (option == null) continue;
            options.add(option);
        }
        return options;
    }

    private static WsdlOption generateWsdlOptionFromArtifact(Artifact artifact, File outputDir) {
        WsdlOption option = new WsdlOption();
        if (WsdlUtilities.fillWsdlOptionFromArtifact(option, artifact, outputDir)) {
            return option;
        }
        return null;
    }

    public static List<GenericWsdlOption> loadWsdlOptionsFromFiles(File wsdlBasedir, String[] includes, String[] excludes, File defaultOutputDir) throws MojoExecutionException {
        if (wsdlBasedir == null) {
            return Collections.emptyList();
        }
        if (!wsdlBasedir.exists()) {
            throw new MojoExecutionException(wsdlBasedir + " does not exist");
        }
        List<File> wsdlFiles = WsdlUtilities.getWsdlFiles(wsdlBasedir, includes, excludes);
        ArrayList<GenericWsdlOption> wsdlOptions = new ArrayList<GenericWsdlOption>();
        for (File wsdl : wsdlFiles) {
            WsdlOption wsdlOption = WsdlOptionLoader.generateWsdlOptionFromFile(wsdl, defaultOutputDir);
            if (wsdlOption == null) continue;
            wsdlOptions.add(wsdlOption);
        }
        return wsdlOptions;
    }

    private static String[] readOptionsFromFile(File dir, String wsdlName) throws MojoExecutionException {
        String[] noOptions = new String[]{};
        List files = FileUtils.getFiles((File)dir, (String)(wsdlName + WSDL_OPTIONS));
        if (files.size() <= 0) {
            return noOptions;
        }
        File optionsFile = (File)files.iterator().next();
        if (optionsFile == null || !optionsFile.exists()) {
            return noOptions;
        }
        try {
            List lines = FileUtils.readLines((File)optionsFile);
            if (lines.size() <= 0) {
                return noOptions;
            }
            return ((String)lines.iterator().next()).split(" ");
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error reading options from file " + optionsFile.getAbsolutePath(), e);
        }
    }

    protected static WsdlOption generateWsdlOptionFromFile(File wsdl, File defaultOutputDir) throws MojoExecutionException {
        List bindingFiles;
        if (wsdl == null || !wsdl.exists()) {
            return null;
        }
        String wsdlFileName = wsdl.getName();
        int idx = wsdlFileName.toLowerCase().lastIndexOf(".wsdl");
        if (idx == -1) {
            idx = wsdlFileName.lastIndexOf(46);
        }
        if (idx == -1) {
            return null;
        }
        WsdlOption wsdlOption = new WsdlOption();
        String wsdlName = wsdlFileName.substring(0, idx);
        String[] options = WsdlOptionLoader.readOptionsFromFile(wsdl.getParentFile(), wsdlName);
        if (options.length > 0) {
            wsdlOption.getExtraargs().addAll(Arrays.asList(options));
        }
        if ((bindingFiles = FileUtils.getFiles((File)wsdl.getParentFile(), (String)(wsdlName + WSDL_BINDINGS))) != null) {
            for (File binding : bindingFiles) {
                wsdlOption.addBindingFile(binding);
            }
        }
        wsdlOption.setWsdl(wsdl.toURI().toString());
        if (wsdlOption.getOutputDir() == null) {
            wsdlOption.setOutputDir(defaultOutputDir);
        }
        return wsdlOption;
    }
}

