/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.maven_plugin;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.net.URI;
import java.net.URL;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.xml.bind.annotation.adapters.HexBinaryAdapter;
import org.apache.commons.lang3.SystemUtils;
import org.apache.cxf.Bus;
import org.apache.cxf.common.util.CollectionUtils;
import org.apache.cxf.common.util.SystemPropertyAction;
import org.apache.cxf.common.util.URIParserUtil;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.helpers.FileUtils;
import org.apache.cxf.maven_plugin.ClassLoaderSwitcher;
import org.apache.cxf.maven_plugin.GenericWsdlOption;
import org.apache.cxf.maven_plugin.WsdlArtifact;
import org.apache.maven.ProjectDependenciesResolver;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.AbstractArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolutionRequest;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.repository.RepositorySystem;
import org.apache.maven.settings.Proxy;
import org.apache.maven.toolchain.Toolchain;
import org.apache.maven.toolchain.ToolchainManager;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.archiver.jar.Manifest;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;
import org.sonatype.plexus.build.incremental.BuildContext;

public abstract class AbstractCodegenMoho
extends AbstractMojo {
    private static final String HTTP_PROXY_HOST = "http.proxyHost";
    private static final String HTTP_PROXY_PORT = "http.proxyPort";
    private static final String HTTP_NON_PROXY_HOSTS = "http.nonProxyHosts";
    private static final String HTTP_PROXY_USER = "http.proxyUser";
    private static final String HTTP_PROXY_PASSWORD = "http.proxyPassword";
    @Parameter(property="project.build.outputDirectory", required=true)
    protected String classesDirectory;
    @Parameter(property="cxf.disableDependencyScan", defaultValue="false")
    protected boolean disableDependencyScan;
    @Parameter(property="cxf.disableDirectoryScan", defaultValue="false")
    protected boolean disableDirectoryScan;
    @Parameter(defaultValue="false")
    protected String fork;
    @Parameter
    protected String[] includes;
    @Parameter(property="cxf.markerDirectory", defaultValue="${project.build.directory}/cxf-codegen-plugin-markers")
    protected File markerDirectory;
    @Parameter(required=true, readonly=true, property="plugin.artifacts")
    protected List<Artifact> pluginArtifacts;
    @Parameter(required=true, property="project")
    protected MavenProject project;
    @Parameter(property="cxf.useCompileClasspath", defaultValue="false")
    protected boolean useCompileClasspath;
    @Parameter
    protected String[] excludes;
    @Parameter(property="cxf.testWsdlRoot", defaultValue="${basedir}/src/test/resources/wsdl")
    protected File testWsdlRoot;
    @Parameter(property="cxf.wsdlRoot", defaultValue="${basedir}/src/main/resources/wsdl")
    protected File wsdlRoot;
    @Component
    protected BuildContext buildContext;
    @Parameter(property="cxf.codegen.jvmArgs")
    private String additionalJvmArgs;
    @Parameter
    private String javaExecutable;
    @Component
    private ToolchainManager toolchainManager;
    @Parameter(readonly=true, required=true, property="session")
    private MavenSession mavenSession;
    @Component
    private ProjectDependenciesResolver projectDependencyResolver;
    @Component
    private RepositorySystem repositorySystem;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException {
        if (System.getProperty("java.version").startsWith("9")) {
            this.fork = "true";
            this.additionalJvmArgs = "--add-modules java.activation,java.xml.bind,java.xml.ws --add-exports=java.xml.bind/com.sun.xml.internal.bind.v2.runtime=ALL-UNNAMED --add-exports=jdk.xml.dom/org.w3c.dom.html=ALL-UNNAMED --add-exports=java.xml/com.sun.org.apache.xerces.internal.impl.xs=ALL-UNNAMED --add-exports=java.xml.bind/com.sun.xml.internal.bind.marshaller=ALL-UNNAMED --add-opens java.xml.ws/javax.xml.ws.wsaddressing=ALL-UNNAMED --add-opens java.base/java.security=ALL-UNNAMED --add-opens java.base/java.net=ALL-UNNAMED --add-opens java.base/java.lang=ALL-UNNAMED --add-opens java.base/java.util=ALL-UNNAMED --add-opens java.base/java.util.concurrent=ALL-UNNAMED " + (this.additionalJvmArgs == null ? "" : this.additionalJvmArgs);
        }
        System.setProperty("org.apache.cxf.JDKBugHacks.defaultUsesCaches", "true");
        if (this.project != null && this.getGeneratedSourceRoot() != null) {
            this.project.addCompileSourceRoot(this.getGeneratedSourceRoot().getAbsolutePath());
        }
        if (this.project != null && this.getGeneratedTestRoot() != null) {
            this.project.addTestCompileSourceRoot(this.getGeneratedTestRoot().getAbsolutePath());
        }
        this.checkResources();
        if (this.project != null && this.buildContext.isIncremental() && !this.buildContext.hasDelta(this.project.getBasedir())) {
            return;
        }
        File classesDir = new File(this.classesDirectory);
        classesDir.mkdirs();
        if (this.includes == null) {
            this.includes = new String[]{"*.wsdl"};
        }
        this.markerDirectory.mkdirs();
        String originalProxyHost = SystemPropertyAction.getProperty((String)HTTP_PROXY_HOST);
        String originalProxyPort = SystemPropertyAction.getProperty((String)HTTP_PROXY_PORT);
        String originalNonProxyHosts = SystemPropertyAction.getProperty((String)HTTP_NON_PROXY_HOSTS);
        String originalProxyUser = SystemPropertyAction.getProperty((String)HTTP_PROXY_USER);
        String originalProxyPassword = SystemPropertyAction.getProperty((String)HTTP_PROXY_PASSWORD);
        Bus bus = null;
        ClassLoaderSwitcher classLoaderSwitcher = null;
        try {
            this.configureProxyServerSettings();
            List<GenericWsdlOption> effectiveWsdlOptions = this.createWsdlOptionsFromScansAndExplicitWsdlOptions();
            if (effectiveWsdlOptions.size() == 0) {
                this.getLog().info((CharSequence)"Nothing to generate");
                return;
            }
            classLoaderSwitcher = new ClassLoaderSwitcher(this.getLog());
            boolean result = true;
            Set<URI> cp = classLoaderSwitcher.switchClassLoader(this.project, this.useCompileClasspath, classesDir);
            if ("once".equals(this.fork) || "true".equals(this.fork)) {
                this.forkOnce(cp, effectiveWsdlOptions);
            } else {
                for (GenericWsdlOption o : effectiveWsdlOptions) {
                    bus = this.generate(o, bus, cp);
                    File[] dirs = o.getDeleteDirs();
                    if (dirs == null) continue;
                    for (int idx = 0; idx < dirs.length; ++idx) {
                        result = result && this.deleteDir(dirs[idx]);
                    }
                }
            }
        }
        finally {
            if (bus != null) {
                bus.shutdown(true);
            }
            if (classLoaderSwitcher != null) {
                classLoaderSwitcher.restoreClassLoader();
            }
            this.restoreProxySetting(originalProxyHost, originalProxyPort, originalNonProxyHosts, originalProxyUser, originalProxyPassword);
        }
        this.checkResources();
        if (this.project != null && this.getGeneratedSourceRoot() != null && this.getGeneratedSourceRoot().exists()) {
            this.buildContext.refresh(this.getGeneratedSourceRoot().getAbsoluteFile());
        }
        if (this.project != null && this.getGeneratedTestRoot() != null && this.getGeneratedTestRoot().exists()) {
            this.buildContext.refresh(this.getGeneratedTestRoot().getAbsoluteFile());
        }
        System.gc();
    }

    private void checkResources() {
        Resource r2;
        File d;
        List resources;
        File root = this.project.getBasedir();
        Resource sourceRoot = null;
        Resource testRoot = null;
        File genroot = this.getGeneratedSourceRoot();
        if (genroot != null) {
            resources = this.project.getBuild().getResources();
            for (Resource r : resources) {
                d = new File(root, r.getDirectory());
                if (!d.equals(genroot)) continue;
                sourceRoot = r;
            }
            r2 = this.scanForResources(genroot, sourceRoot);
            if (r2 != sourceRoot) {
                r2.setDirectory(this.getGeneratedSourceRoot().getAbsolutePath());
                this.project.addResource(r2);
            }
        }
        if ((genroot = this.getGeneratedTestRoot()) != null) {
            resources = this.project.getBuild().getTestResources();
            for (Resource r : resources) {
                d = new File(root, r.getDirectory());
                if (!d.equals(genroot)) continue;
                testRoot = r;
            }
            r2 = this.scanForResources(genroot, testRoot);
            if (r2 != testRoot) {
                r2.setDirectory(this.getGeneratedTestRoot().getAbsolutePath());
                this.project.addTestResource(r2);
            }
        }
    }

    private Resource scanForResources(File rootFile, Resource root) {
        File[] files = rootFile.listFiles();
        if (files == null) {
            return root;
        }
        for (File f : files) {
            if (f.isDirectory()) {
                root = this.scanForResources(f, root);
                continue;
            }
            if (f.getName().endsWith(".java")) continue;
            String n = f.getName();
            int idx = n.lastIndexOf(46);
            if (idx != -1) {
                n = "**/*" + n.substring(idx);
            }
            if (root == null) {
                root = new Resource();
            }
            if (root.getIncludes().contains(n)) continue;
            root.addInclude(n);
        }
        return root;
    }

    private void restoreProxySetting(String originalProxyHost, String originalProxyPort, String originalNonProxyHosts, String originalProxyUser, String originalProxyPassword) {
        if (originalProxyHost != null) {
            System.setProperty(HTTP_PROXY_HOST, originalProxyHost);
        } else {
            System.getProperties().remove(HTTP_PROXY_HOST);
        }
        if (originalProxyPort != null) {
            System.setProperty(HTTP_PROXY_PORT, originalProxyPort);
        } else {
            System.getProperties().remove(HTTP_PROXY_PORT);
        }
        if (originalNonProxyHosts != null) {
            System.setProperty(HTTP_NON_PROXY_HOSTS, originalNonProxyHosts);
        } else {
            System.getProperties().remove(HTTP_NON_PROXY_HOSTS);
        }
        if (originalProxyUser != null) {
            System.setProperty(HTTP_PROXY_USER, originalProxyUser);
        } else {
            System.getProperties().remove(HTTP_PROXY_USER);
        }
        if (originalProxyPassword != null) {
            System.setProperty(HTTP_PROXY_PASSWORD, originalProxyPassword);
        } else {
            System.getProperties().remove(HTTP_PROXY_PASSWORD);
        }
        Proxy proxy = this.mavenSession.getSettings().getActiveProxy();
        if (proxy != null && !StringUtils.isEmpty((String)proxy.getUsername()) && !StringUtils.isEmpty((String)proxy.getPassword())) {
            Authenticator.setDefault(null);
        }
    }

    protected abstract Bus generate(GenericWsdlOption var1, Bus var2, Set<URI> var3) throws MojoExecutionException;

    protected void addPluginArtifact(Set<URI> artifactsPath) {
        URL url = ((Object)((Object)this)).getClass().getResource(((Object)((Object)this)).getClass().getSimpleName() + ".class");
        try {
            File file;
            URI uri;
            String s;
            if ("jar".equals(url.getProtocol()) && (s = url.getPath()).contains("!")) {
                s = s.substring(0, s.indexOf(33));
                url = new URL(s);
            }
            if ((uri = new URI(url.getProtocol(), null, url.getPath(), null, null)).getSchemeSpecificPart().endsWith(".class")) {
                String s2 = uri.toString();
                s2 = s2.substring(0, s2.length() - 6 - ((Object)((Object)this)).getClass().getName().length());
                uri = new URI(s2);
            }
            if ((file = new File(uri)).exists()) {
                artifactsPath.add(file.toURI());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void configureProxyServerSettings() throws MojoExecutionException {
        Proxy proxy = this.mavenSession.getSettings().getActiveProxy();
        if (proxy != null) {
            this.getLog().info((CharSequence)"Using proxy server configured in maven.");
            if (proxy.getHost() == null) {
                throw new MojoExecutionException("Proxy in settings.xml has no host");
            }
            if (proxy.getHost() != null) {
                System.setProperty(HTTP_PROXY_HOST, proxy.getHost());
            }
            if (String.valueOf(proxy.getPort()) != null) {
                System.setProperty(HTTP_PROXY_PORT, String.valueOf(proxy.getPort()));
            }
            if (proxy.getNonProxyHosts() != null) {
                System.setProperty(HTTP_NON_PROXY_HOSTS, proxy.getNonProxyHosts());
            }
            if (!StringUtils.isEmpty((String)proxy.getUsername()) && !StringUtils.isEmpty((String)proxy.getPassword())) {
                final String authUser = proxy.getUsername();
                final String authPassword = proxy.getPassword();
                Authenticator.setDefault(new Authenticator(){

                    @Override
                    public PasswordAuthentication getPasswordAuthentication() {
                        return new PasswordAuthentication(authUser, authPassword.toCharArray());
                    }
                });
                System.setProperty(HTTP_PROXY_USER, authUser);
                System.setProperty(HTTP_PROXY_PORT, authPassword);
            }
        }
    }

    protected abstract List<GenericWsdlOption> createWsdlOptionsFromScansAndExplicitWsdlOptions() throws MojoExecutionException;

    protected boolean deleteDir(File f) {
        File[] files;
        if (f.isDirectory() && (files = f.listFiles()) != null) {
            for (int idx = 0; idx < files.length; ++idx) {
                this.deleteDir(files[idx]);
            }
        }
        if (f.exists()) {
            return f.delete();
        }
        this.buildContext.refresh(f.getParentFile());
        return true;
    }

    protected abstract String getMarkerSuffix();

    protected List<String> generateCommandLine(GenericWsdlOption wsdlOption) throws MojoExecutionException {
        File outputDirFile = wsdlOption.getOutputDir();
        outputDirFile.mkdirs();
        URI basedir = this.project.getBasedir().toURI();
        URI wsdlURI = this.getWsdlURI(wsdlOption, basedir);
        return wsdlOption.generateCommandLine(outputDirFile, basedir, wsdlURI, this.getLog().isDebugEnabled());
    }

    protected void forkOnce(Set<URI> classPath, List<GenericWsdlOption> effectiveWsdlOptions) throws MojoExecutionException {
        LinkedList<GenericWsdlOption> toDo = new LinkedList<GenericWsdlOption>();
        LinkedList<List<String>> wargs = new LinkedList<List<String>>();
        for (GenericWsdlOption genericWsdlOption : effectiveWsdlOptions) {
            File outputDirFile = genericWsdlOption.getOutputDir();
            outputDirFile.mkdirs();
            URI uRI = this.project.getBasedir().toURI();
            URI wsdlURI = this.getWsdlURI(genericWsdlOption, uRI);
            File doneFile = this.getDoneFile(uRI, wsdlURI, this.getMarkerSuffix());
            if (!this.shouldRun(genericWsdlOption, doneFile, wsdlURI)) continue;
            doneFile.delete();
            toDo.add(genericWsdlOption);
            wargs.add(this.generateCommandLine(genericWsdlOption));
        }
        if (wargs.isEmpty()) {
            return;
        }
        LinkedHashSet<URI> artifactsPath = new LinkedHashSet<URI>();
        for (Artifact a : this.pluginArtifacts) {
            File file = a.getFile();
            if (file == null) {
                throw new MojoExecutionException("Unable to find file for artifact " + a.getGroupId() + ":" + a.getArtifactId() + ":" + a.getVersion());
            }
            artifactsPath.add(file.toURI());
        }
        this.addPluginArtifact(artifactsPath);
        artifactsPath.addAll(classPath);
        String[] stringArray = this.createForkOnceArgs(wargs);
        this.runForked(artifactsPath, this.getForkClass().getName(), stringArray);
        for (GenericWsdlOption genericWsdlOption : toDo) {
            File[] dirs = genericWsdlOption.getDeleteDirs();
            if (dirs != null) {
                for (int idx = 0; idx < dirs.length; ++idx) {
                    this.deleteDir(dirs[idx]);
                }
            }
            URI basedir = this.project.getBasedir().toURI();
            URI wsdlURI = this.getWsdlURI(genericWsdlOption, basedir);
            File doneFile = this.getDoneFile(basedir, wsdlURI, this.getMarkerSuffix());
            try {
                this.createMarkerFile(genericWsdlOption, doneFile, wsdlURI);
            }
            catch (Throwable e) {
                this.getLog().warn((CharSequence)("Could not create marker file " + doneFile.getAbsolutePath()));
                this.getLog().debug(e);
            }
        }
    }

    protected abstract Class<?> getForkClass();

    protected File getDoneFile(URI basedir, URI wsdlURI, String mojo) {
        String doneFileName = mojo + wsdlURI.toString();
        try {
            MessageDigest cript = MessageDigest.getInstance("SHA-1");
            cript.reset();
            cript.update(doneFileName.getBytes("utf8"));
            doneFileName = new HexBinaryAdapter().marshal(cript.digest());
        }
        catch (Exception e) {
            if (doneFileName.startsWith(basedir.toString())) {
                doneFileName = doneFileName.substring(basedir.toString().length());
            }
            doneFileName = doneFileName.replace('?', '_').replace('&', '_').replace('/', '_').replace('\\', '_').replace(':', '_');
            doneFileName = doneFileName + ".DONE";
        }
        return new File(this.markerDirectory, "." + doneFileName);
    }

    protected abstract File getGeneratedSourceRoot();

    protected abstract File getGeneratedTestRoot();

    protected void runForked(Set<URI> classPath, String mainClassName, String[] args) throws MojoExecutionException {
        StringBuilder msg;
        int exitCode;
        this.getLog().info((CharSequence)"Running code generation in fork mode...");
        this.getLog().debug((CharSequence)("Running code generation in fork mode with args " + Arrays.asList(args)));
        Commandline cmd = new Commandline();
        cmd.getShell().setQuotedArgumentsEnabled(true);
        cmd.setWorkingDirectory(this.project.getBuild().getDirectory());
        try {
            cmd.setExecutable(this.getJavaExecutable().getAbsolutePath());
        }
        catch (IOException e) {
            this.getLog().debug((Throwable)e);
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        cmd.createArg().setLine(this.additionalJvmArgs);
        File file = null;
        try {
            file = FileUtils.createTempFile((String)"cxf-codegen", (String)".jar");
            JarArchiver jar = new JarArchiver();
            jar.setDestFile(file.getAbsoluteFile());
            Manifest manifest = new Manifest();
            Manifest.Attribute attr = new Manifest.Attribute();
            attr.setName("Class-Path");
            StringBuilder b = new StringBuilder(8000);
            for (URI cp : classPath) {
                b.append(cp.toURL().toExternalForm()).append(' ');
            }
            attr.setValue(b.toString());
            manifest.getMainSection().addConfiguredAttribute(attr);
            attr = new Manifest.Attribute();
            attr.setName("Main-Class");
            attr.setValue(mainClassName);
            manifest.getMainSection().addConfiguredAttribute(attr);
            jar.addConfiguredManifest(manifest);
            jar.createArchive();
            cmd.createArg().setValue("-jar");
            String tmpFilePath = file.getAbsolutePath();
            if (tmpFilePath.contains(" ")) {
                tmpFilePath = "\"" + tmpFilePath + "\"";
            }
            cmd.createArg().setValue(tmpFilePath);
        }
        catch (Exception e1) {
            throw new MojoExecutionException("Could not create runtime jar", e1);
        }
        cmd.addArguments(args);
        StreamConsumer out = new StreamConsumer(){

            public void consumeLine(String line) {
                AbstractCodegenMoho.this.getLog().info((CharSequence)line);
            }
        };
        final StringBuilder b = new StringBuilder();
        StreamConsumer err = new StreamConsumer(){

            public void consumeLine(String line) {
                b.append(line);
                b.append("\n");
                AbstractCodegenMoho.this.getLog().warn((CharSequence)line);
            }
        };
        try {
            exitCode = CommandLineUtils.executeCommandLine((Commandline)cmd, (StreamConsumer)out, (StreamConsumer)err);
        }
        catch (CommandLineException e) {
            this.getLog().debug((Throwable)e);
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
        String cmdLine = CommandLineUtils.toString((String[])cmd.getCommandline());
        if (exitCode != 0) {
            msg = new StringBuilder("\nExit code: ");
            msg.append(exitCode);
            msg.append('\n');
            msg.append("Command line was: ").append(cmdLine).append('\n').append('\n');
            throw new MojoExecutionException(msg.toString());
        }
        file.delete();
        if (b.toString().contains("WSDL2Java Error")) {
            msg = new StringBuilder();
            msg.append(b.toString());
            msg.append('\n');
            msg.append("Command line was: ").append(cmdLine).append('\n').append('\n');
            throw new MojoExecutionException(msg.toString());
        }
    }

    protected abstract boolean shouldRun(GenericWsdlOption var1, File var2, URI var3);

    protected void createMarkerFile(GenericWsdlOption wsdlOption, File doneFile, URI wsdlURI) throws IOException {
        doneFile.createNewFile();
    }

    private String[] createForkOnceArgs(List<List<String>> wargs) throws MojoExecutionException {
        try {
            File f = FileUtils.createTempFile((String)"cxf-w2j", (String)"args");
            PrintWriter fw = new PrintWriter(new FileWriter(f));
            for (List<String> args : wargs) {
                fw.println(Integer.toString(args.size()));
                for (String s : args) {
                    fw.println(s);
                }
            }
            fw.println("-1");
            fw.close();
            return new String[]{f.getAbsolutePath()};
        }
        catch (IOException ex) {
            throw new MojoExecutionException("Could not create argument file", (Exception)ex);
        }
    }

    public File getWsdlFile(GenericWsdlOption option, File baseDir) {
        if (option.getUri() == null) {
            return null;
        }
        File file = null;
        try {
            URI uri = new URI(option.getUri());
            if (uri.isAbsolute()) {
                file = new File(uri);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (file == null || !file.exists()) {
            file = new File(option.getUri());
        }
        if (!file.exists()) {
            file = new File(baseDir, option.getUri());
        }
        return file;
    }

    public URI getWsdlURI(GenericWsdlOption option, URI baseURI) throws MojoExecutionException {
        String wsdlLocation = option.getUri();
        if (wsdlLocation == null) {
            throw new MojoExecutionException("No wsdl available for base URI " + baseURI);
        }
        File wsdlFile = new File(wsdlLocation);
        return wsdlFile.exists() ? wsdlFile.toURI() : baseURI.resolve(URIParserUtil.escapeChars((String)wsdlLocation));
    }

    protected void downloadRemoteWsdls(List<GenericWsdlOption> effectiveWsdlOptions) throws MojoExecutionException {
        for (GenericWsdlOption wsdlOption : effectiveWsdlOptions) {
            WsdlArtifact wsdlA = wsdlOption.getArtifact();
            if (wsdlA == null) continue;
            Artifact wsdlArtifact = this.repositorySystem.createArtifactWithClassifier(wsdlA.getGroupId(), wsdlA.getArtifactId(), wsdlA.getVersion(), wsdlA.getType(), wsdlA.getClassifier());
            if ((wsdlArtifact = this.resolveRemoteWsdlArtifact(wsdlArtifact)) == null) continue;
            File supposedFile = wsdlArtifact.getFile();
            if (!supposedFile.exists() || !supposedFile.isFile()) {
                this.getLog().info((CharSequence)("Apparent Maven bug: wsdl artifact 'resolved' to " + supposedFile.getAbsolutePath() + " for " + wsdlArtifact.toString()));
                continue;
            }
            String path = supposedFile.getAbsolutePath();
            this.getLog().info((CharSequence)("Resolved WSDL artifact to file " + path));
            wsdlOption.setUri(path);
        }
    }

    private File getJavaExecutable() throws IOException {
        if (this.javaExecutable != null) {
            this.getLog().debug((CharSequence)("Plugin configuration set the 'javaExecutable' parameter to " + this.javaExecutable));
        } else {
            Toolchain tc = this.toolchainManager.getToolchainFromBuildContext("jdk", this.mavenSession);
            if (tc != null) {
                this.getLog().info((CharSequence)("Using toolchain " + tc + " to find the java executable"));
                this.javaExecutable = tc.findTool("java");
            } else {
                this.getLog().debug((CharSequence)"The java executable is set to default value");
                this.javaExecutable = SystemUtils.getJavaHome() + File.separator + "bin" + File.separator + "java";
            }
        }
        String exe = SystemUtils.IS_OS_WINDOWS && !this.javaExecutable.endsWith(".exe") ? ".exe" : "";
        File javaExe = new File(this.javaExecutable + exe);
        if (!javaExe.isFile()) {
            throw new IOException("The java executable '" + javaExe + "' doesn't exist or is not a file.Verify the <javaExecutable/> parameter or toolchain configuration.");
        }
        this.getLog().info((CharSequence)("The java executable is " + javaExe.getAbsolutePath()));
        return javaExe;
    }

    private Artifact resolveRemoteWsdlArtifact(Artifact artifact) throws MojoExecutionException {
        Artifact remoteWsdl = this.resolveDependentWsdl(artifact);
        if (remoteWsdl == null) {
            remoteWsdl = this.resolveAttachedWsdl(artifact);
        }
        if (remoteWsdl == null) {
            remoteWsdl = this.resolveArbitraryWsdl(artifact);
        }
        if (remoteWsdl != null && remoteWsdl.isResolved()) {
            return remoteWsdl;
        }
        throw new MojoExecutionException(String.format("Failed to resolve WSDL artifact %s", artifact.toString()));
    }

    private Artifact resolveDependentWsdl(Artifact artifact) {
        ArrayList<String> scopes = new ArrayList<String>();
        scopes.add("runtime");
        Set artifactSet = null;
        try {
            artifactSet = this.projectDependencyResolver.resolve(this.project, scopes, this.mavenSession);
        }
        catch (AbstractArtifactResolutionException e) {
            this.getLog().info((CharSequence)"Error resolving dependent wsdl artifact.", (Throwable)e);
        }
        return this.findWsdlArtifact(artifact, artifactSet);
    }

    private Artifact resolveAttachedWsdl(Artifact artifact) {
        List rProjects = this.mavenSession.getProjects();
        ArrayList<Artifact> artifactList = new ArrayList<Artifact>();
        for (MavenProject rProject : rProjects) {
            List list = CastUtils.cast((List)rProject.getAttachedArtifacts());
            if (list == null) continue;
            artifactList.addAll(list);
        }
        return this.findWsdlArtifact(artifact, artifactList);
    }

    private Artifact resolveArbitraryWsdl(Artifact artifact) {
        ArtifactResolutionRequest request = new ArtifactResolutionRequest();
        request.setArtifact(artifact);
        request.setResolveRoot(true).setResolveTransitively(false);
        request.setServers(this.mavenSession.getRequest().getServers());
        request.setMirrors(this.mavenSession.getRequest().getMirrors());
        request.setProxies(this.mavenSession.getRequest().getProxies());
        request.setLocalRepository(this.mavenSession.getLocalRepository());
        request.setRemoteRepositories(this.mavenSession.getRequest().getRemoteRepositories());
        ArtifactResolutionResult result = this.repositorySystem.resolve(request);
        Artifact resolvedArtifact = result.getOriginatingArtifact();
        if (resolvedArtifact == null && !CollectionUtils.isEmpty((Collection)result.getArtifacts())) {
            resolvedArtifact = (Artifact)result.getArtifacts().iterator().next();
        }
        return resolvedArtifact;
    }

    private Artifact findWsdlArtifact(Artifact targetArtifact, Collection<Artifact> artifactSet) {
        if (artifactSet != null && !artifactSet.isEmpty()) {
            for (Artifact pArtifact : artifactSet) {
                if (!targetArtifact.getGroupId().equals(pArtifact.getGroupId()) || !targetArtifact.getArtifactId().equals(pArtifact.getArtifactId()) || !targetArtifact.getVersion().equals(pArtifact.getVersion()) || !"wsdl".equals(pArtifact.getType()) && (targetArtifact.getClassifier() == null || pArtifact.getType() == null || !(targetArtifact.getClassifier() + ".wsdl").equals(pArtifact.getType()))) continue;
                return pArtifact;
            }
        }
        return null;
    }
}

