/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.policy.attachment.external;

import java.util.Collection;
import java.util.Collections;
import java.util.ResourceBundle;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import org.apache.cxf.common.i18n.BundleUtils;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.util.PackageUtils;
import org.apache.cxf.ws.addressing.EndpointReferenceType;
import org.apache.cxf.ws.policy.PolicyException;
import org.apache.cxf.ws.policy.attachment.external.DomainExpression;
import org.apache.cxf.ws.policy.attachment.external.DomainExpressionBuilder;
import org.apache.cxf.ws.policy.attachment.external.EndpointReferenceDomainExpression;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EndpointReferenceDomainExpressionBuilder
implements DomainExpressionBuilder {
    private static final ResourceBundle BUNDLE = BundleUtils.getBundle(EndpointReferenceDomainExpressionBuilder.class);
    private static final Collection<QName> SUPPORTED_TYPES = Collections.singletonList(new QName("http://www.w3.org/2005/08/addressing", "EndpointReference"));
    private Unmarshaller unmarshaller;

    @Override
    public Collection<QName> getDomainExpressionTypes() {
        return SUPPORTED_TYPES;
    }

    @Override
    public DomainExpression build(Element e) {
        Object obj = null;
        try {
            obj = this.getUnmarshaller().unmarshal((Node)e);
        }
        catch (JAXBException ex) {
            throw new PolicyException(new Message("EPR_DOMAIN_EXPRESSION_BUILD_EXC", BUNDLE, (Object[])null), ex);
        }
        if (obj instanceof JAXBElement) {
            JAXBElement el = (JAXBElement)obj;
            obj = el.getValue();
        }
        EndpointReferenceDomainExpression eprde = new EndpointReferenceDomainExpression();
        eprde.setEndpointReference((EndpointReferenceType)obj);
        return eprde;
    }

    protected Unmarshaller getUnmarshaller() {
        if (this.unmarshaller == null) {
            this.createUnmarshaller();
        }
        return this.unmarshaller;
    }

    protected synchronized void createUnmarshaller() {
        if (this.unmarshaller != null) {
            return;
        }
        try {
            Class<EndpointReferenceType> clz = EndpointReferenceType.class;
            String pkg = PackageUtils.getPackageName(clz);
            JAXBContext context = JAXBContext.newInstance((String)pkg, (ClassLoader)clz.getClassLoader());
            this.unmarshaller = context.createUnmarshaller();
        }
        catch (JAXBException ex) {
            throw new PolicyException(new Message("EPR_DOMAIN_EXPRESSION_BUILDER_INIT_EXC", BUNDLE, (Object[])null), ex);
        }
    }
}

