/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.source;

import java.util.Iterator;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.excalibur.source.SourceParameters;
import org.apache.excalibur.source.SourceUtil;

public abstract class AvalonSourceUtil {
    public static SourceParameters createSourceParameters(Configuration conf) {
        Configuration[] children = conf.getChildren();
        if (children != null && children.length > 0) {
            SourceParameters pars = new SourceParameters();
            for (int i = 0; i < children.length; ++i) {
                String value;
                String name = children[i].getName();
                try {
                    value = children[i].getValue();
                }
                catch (ConfigurationException local) {
                    value = "";
                }
                pars.setParameter(name, value);
            }
            return pars;
        }
        return null;
    }

    public static Parameters getFirstParameters(SourceParameters params) {
        Parameters result = new Parameters();
        Iterator iter = params.getParameterNames();
        while (iter.hasNext()) {
            String parName = (String)iter.next();
            result.setParameter(parName, params.getParameter(parName));
        }
        return result;
    }

    public static String appendParameters(String uri, Parameters parameters) {
        if (parameters != null) {
            int separator;
            StringBuffer buffer = new StringBuffer(uri);
            String[] keys = parameters.getNames();
            int n = separator = uri.indexOf("?") == -1 ? 63 : 38;
            if (keys != null) {
                for (int i = 0; i < keys.length; ++i) {
                    String current = keys[i];
                    buffer.append((char)separator).append(current).append('=').append(SourceUtil.encode(parameters.getParameter(current, null)));
                    separator = 38;
                }
            }
            return buffer.toString();
        }
        return uri;
    }
}

