/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.xml.sax;

import java.util.Enumeration;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DocumentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributeListImpl;
import org.xml.sax.helpers.NamespaceSupport;

public class DocumentHandlerAdapter
implements ContentHandler {
    private static final String XMLNS = "xmlns";
    private static final String XMLNS_PREFIX = "xmlns:";
    private static final String CDATA = "CDATA";
    private final DocumentHandler m_documentHandler;
    private final NamespaceSupport m_support = new NamespaceSupport();
    private boolean m_contextPushed = false;

    public DocumentHandlerAdapter(DocumentHandler documentHandler) {
        this.m_documentHandler = documentHandler;
    }

    public void setDocumentLocator(Locator locator) {
        this.m_documentHandler.setDocumentLocator(locator);
    }

    public void startDocument() throws SAXException {
        this.m_documentHandler.startDocument();
    }

    public void endDocument() throws SAXException {
        this.m_documentHandler.endDocument();
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        if (!this.m_contextPushed) {
            this.m_support.pushContext();
            this.m_contextPushed = true;
        }
        this.m_support.declarePrefix(prefix, uri);
    }

    public void endPrefixMapping(String prefix) throws SAXException {
    }

    public void startElement(String uri, String loc, String raw, Attributes a) throws SAXException {
        if (!this.m_contextPushed) {
            this.m_support.pushContext();
        }
        this.m_contextPushed = false;
        String name = this.getTagName(loc, raw, uri);
        AttributeListImpl attributeList = new AttributeListImpl();
        for (int i = 0; i < a.getLength(); ++i) {
            String attributeName = a.getQName(i);
            if (attributeName == null || attributeName.length() == 0) {
                String attributeNamespaceURI = a.getURI(i);
                String attributeLocalName = a.getLocalName(i);
                if (attributeNamespaceURI.length() == 0) {
                    attributeName = attributeLocalName;
                } else {
                    String prefix = this.m_support.getPrefix(attributeNamespaceURI);
                    if (prefix == null) {
                        throw new SAXException("No attribute prefix for namespace URI: " + attributeNamespaceURI);
                    }
                    attributeName = prefix + ':' + attributeLocalName;
                }
            }
            attributeList.addAttribute(attributeName, a.getType(i), a.getValue(i));
        }
        Enumeration<String> e = this.m_support.getDeclaredPrefixes();
        while (e.hasMoreElements()) {
            String prefix = e.nextElement();
            if (prefix.length() == 0) {
                attributeList.addAttribute(XMLNS, CDATA, uri);
                continue;
            }
            attributeList.addAttribute(XMLNS_PREFIX + prefix, CDATA, uri);
        }
        this.m_documentHandler.startElement(name, attributeList);
    }

    public void endElement(String uri, String loc, String raw) throws SAXException {
        String name = this.getTagName(loc, raw, uri);
        this.m_documentHandler.endElement(name);
        this.m_support.popContext();
    }

    public void characters(char[] ch, int start, int len) throws SAXException {
        this.m_documentHandler.characters(ch, start, len);
    }

    public void ignorableWhitespace(char[] ch, int start, int len) throws SAXException {
        this.m_documentHandler.ignorableWhitespace(ch, start, len);
    }

    public void processingInstruction(String target, String data) throws SAXException {
        this.m_documentHandler.processingInstruction(target, data);
    }

    public void skippedEntity(String name) throws SAXException {
    }

    private String getTagName(String loc, String raw, String uri) throws SAXException {
        if (raw != null && raw.length() > 0) {
            return raw;
        }
        String prefix = this.getTagPrefix(uri);
        return (prefix.length() == 0 ? "" : prefix + ':') + loc;
    }

    private String getTagPrefix(String uri) throws SAXException {
        if (this.m_support.getPrefix(uri) == null) {
            if (uri == null || uri.length() < 1) {
                return "";
            }
            String defaultURI = this.m_support.getURI("");
            if (defaultURI != null && defaultURI.equals(uri)) {
                return "";
            }
            throw new SAXException("No element prefix for namespace URI: " + uri);
        }
        return this.m_support.getPrefix(uri);
    }
}

