/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.client.program;

import java.net.URL;
import java.util.List;
import org.apache.flink.api.common.JobExecutionResult;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.JobSubmissionResult;
import org.apache.flink.api.common.Plan;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.ExecutionEnvironmentFactory;
import org.apache.flink.api.java.operators.translation.JavaPlan;
import org.apache.flink.client.program.Client;
import org.apache.flink.client.program.JobWithJars;
import org.apache.flink.optimizer.plan.OptimizedPlan;
import org.apache.flink.optimizer.plandump.PlanJSONDumpGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContextEnvironment
extends ExecutionEnvironment {
    private static final Logger LOG = LoggerFactory.getLogger(ContextEnvironment.class);
    private final Client client;
    private final List<URL> jarFilesToAttach;
    private final List<URL> classpathsToAttach;
    private final ClassLoader userCodeClassLoader;
    private final boolean wait;

    public ContextEnvironment(Client remoteConnection, List<URL> jarFiles, List<URL> classpaths, ClassLoader userCodeClassLoader, boolean wait) {
        this.client = remoteConnection;
        this.jarFilesToAttach = jarFiles;
        this.classpathsToAttach = classpaths;
        this.userCodeClassLoader = userCodeClassLoader;
        this.wait = wait;
    }

    public JobExecutionResult execute(String jobName) throws Exception {
        JavaPlan p = this.createProgramPlan(jobName);
        JobWithJars toRun = new JobWithJars((Plan)p, this.jarFilesToAttach, this.classpathsToAttach, this.userCodeClassLoader);
        if (this.wait) {
            this.lastJobExecutionResult = this.client.runBlocking(toRun, this.getParallelism());
            return this.lastJobExecutionResult;
        }
        JobSubmissionResult result = this.client.runDetached(toRun, this.getParallelism());
        LOG.warn("Job was executed in detached mode, the results will be available on completion.");
        this.lastJobExecutionResult = JobExecutionResult.fromJobSubmissionResult((JobSubmissionResult)result);
        return this.lastJobExecutionResult;
    }

    public String getExecutionPlan() throws Exception {
        JavaPlan plan = this.createProgramPlan("unnamed job");
        OptimizedPlan op = Client.getOptimizedPlan(this.client.compiler, (Plan)plan, this.getParallelism());
        PlanJSONDumpGenerator gen = new PlanJSONDumpGenerator();
        return gen.getOptimizerPlanAsJSON(op);
    }

    public void startNewSession() throws Exception {
        this.client.endSession(this.jobID);
        this.jobID = JobID.generate();
    }

    public boolean isWait() {
        return this.wait;
    }

    public String toString() {
        return "Context Environment (parallelism = " + (this.getParallelism() == -1 ? "default" : Integer.valueOf(this.getParallelism())) + ") : " + this.getIdString();
    }

    public Client getClient() {
        return this.client;
    }

    public List<URL> getJars() {
        return this.jarFilesToAttach;
    }

    public List<URL> getClasspaths() {
        return this.classpathsToAttach;
    }

    static void setAsContext(Client client, List<URL> jarFilesToAttach, List<URL> classpathsToAttach, ClassLoader userCodeClassLoader, int defaultParallelism, boolean wait) {
        ContextEnvironmentFactory factory = new ContextEnvironmentFactory(client, jarFilesToAttach, classpathsToAttach, userCodeClassLoader, defaultParallelism, wait);
        ContextEnvironment.initializeContextEnvironment((ExecutionEnvironmentFactory)factory);
    }

    static void unsetContext() {
        ContextEnvironment.resetContextEnvironment();
    }

    public static class ContextEnvironmentFactory
    implements ExecutionEnvironmentFactory {
        private final Client client;
        private final List<URL> jarFilesToAttach;
        private final List<URL> classpathsToAttach;
        private final ClassLoader userCodeClassLoader;
        private final int defaultParallelism;
        private final boolean wait;

        public ContextEnvironmentFactory(Client client, List<URL> jarFilesToAttach, List<URL> classpathsToAttach, ClassLoader userCodeClassLoader, int defaultParallelism, boolean wait) {
            this.client = client;
            this.jarFilesToAttach = jarFilesToAttach;
            this.classpathsToAttach = classpathsToAttach;
            this.userCodeClassLoader = userCodeClassLoader;
            this.defaultParallelism = defaultParallelism;
            this.wait = wait;
        }

        public ExecutionEnvironment createExecutionEnvironment() {
            ContextEnvironment env = new ContextEnvironment(this.client, this.jarFilesToAttach, this.classpathsToAttach, this.userCodeClassLoader, this.wait);
            if (this.defaultParallelism > 0) {
                env.setParallelism(this.defaultParallelism);
            }
            return env;
        }
    }
}

