/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.client.program;

import java.io.File;
import java.util.List;
import org.apache.flink.api.common.JobExecutionResult;
import org.apache.flink.api.common.JobSubmissionResult;
import org.apache.flink.api.common.Plan;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.ExecutionEnvironmentFactory;
import org.apache.flink.api.java.operators.translation.JavaPlan;
import org.apache.flink.client.program.Client;
import org.apache.flink.client.program.JobWithJars;
import org.apache.flink.optimizer.plan.OptimizedPlan;
import org.apache.flink.optimizer.plandump.PlanJSONDumpGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContextEnvironment
extends ExecutionEnvironment {
    private static final Logger LOG = LoggerFactory.getLogger(ContextEnvironment.class);
    private final Client client;
    private final List<File> jarFilesToAttach;
    private final ClassLoader userCodeClassLoader;
    private final boolean wait;

    public ContextEnvironment(Client remoteConnection, List<File> jarFiles, ClassLoader userCodeClassLoader, boolean wait) {
        this.client = remoteConnection;
        this.jarFilesToAttach = jarFiles;
        this.userCodeClassLoader = userCodeClassLoader;
        this.wait = wait;
    }

    public JobExecutionResult execute(String jobName) throws Exception {
        JavaPlan p = this.createProgramPlan(jobName);
        JobWithJars toRun = new JobWithJars((Plan)p, this.jarFilesToAttach, this.userCodeClassLoader);
        JobSubmissionResult result = this.client.run(toRun, this.getParallelism(), this.wait);
        if (result instanceof JobExecutionResult) {
            this.lastJobExecutionResult = (JobExecutionResult)result;
            return (JobExecutionResult)result;
        }
        LOG.warn("The Client didn't return a JobExecutionResult");
        this.lastJobExecutionResult = new JobExecutionResult(result.getJobID(), -1L, null);
        return this.lastJobExecutionResult;
    }

    public String getExecutionPlan() throws Exception {
        JavaPlan p = this.createProgramPlan("unnamed job");
        OptimizedPlan op = (OptimizedPlan)this.client.getOptimizedPlan((Plan)p, this.getParallelism());
        PlanJSONDumpGenerator gen = new PlanJSONDumpGenerator();
        return gen.getOptimizerPlanAsJSON(op);
    }

    public boolean isWait() {
        return this.wait;
    }

    public String toString() {
        return "Context Environment (parallelism = " + (this.getParallelism() == -1 ? "default" : Integer.valueOf(this.getParallelism())) + ") : " + this.getIdString();
    }

    public Client getClient() {
        return this.client;
    }

    public List<File> getJars() {
        return this.jarFilesToAttach;
    }

    static void setAsContext(Client client, List<File> jarFilesToAttach, ClassLoader userCodeClassLoader, int defaultParallelism, boolean wait) {
        ContextEnvironment.initializeContextEnvironment((ExecutionEnvironmentFactory)new ContextEnvironmentFactory(client, jarFilesToAttach, userCodeClassLoader, defaultParallelism, wait));
    }

    protected static void enableLocalExecution(boolean enabled) {
        ExecutionEnvironment.enableLocalExecution((boolean)enabled);
    }

    public static class ContextEnvironmentFactory
    implements ExecutionEnvironmentFactory {
        private final Client client;
        private final List<File> jarFilesToAttach;
        private final ClassLoader userCodeClassLoader;
        private final int defaultParallelism;
        private final boolean wait;

        public ContextEnvironmentFactory(Client client, List<File> jarFilesToAttach, ClassLoader userCodeClassLoader, int defaultParallelism, boolean wait) {
            this.client = client;
            this.jarFilesToAttach = jarFilesToAttach;
            this.userCodeClassLoader = userCodeClassLoader;
            this.defaultParallelism = defaultParallelism;
            this.wait = wait;
        }

        public ExecutionEnvironment createExecutionEnvironment() {
            ContextEnvironment env = new ContextEnvironment(this.client, this.jarFilesToAttach, this.userCodeClassLoader, this.wait);
            if (this.defaultParallelism > 0) {
                env.setParallelism(this.defaultParallelism);
            }
            return env;
        }
    }
}

