/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Random;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.api.common.accumulators.SerializedListAccumulator;
import org.apache.flink.api.common.functions.RichFlatMapFunction;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.CompositeType;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.functions.FunctionAnnotation;
import org.apache.flink.api.java.typeutils.GenericTypeInfo;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.util.Collector;

public final class Utils {
    public static final Random RNG = new Random();

    public static String getCallLocationName() {
        return Utils.getCallLocationName(4);
    }

    public static String getCallLocationName(int depth) {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        if (stackTrace.length < depth) {
            return "<unknown>";
        }
        StackTraceElement elem = stackTrace[depth];
        return String.format("%s(%s:%d)", elem.getMethodName(), elem.getFileName(), elem.getLineNumber());
    }

    public static void getContainedGenericTypes(CompositeType typeInfo, List<GenericTypeInfo<?>> target) {
        for (int i = 0; i < typeInfo.getArity(); ++i) {
            TypeInformation type = typeInfo.getTypeAt(i);
            if (type instanceof CompositeType) {
                Utils.getContainedGenericTypes((CompositeType)type, target);
                continue;
            }
            if (!(type instanceof GenericTypeInfo) || target.contains(type)) continue;
            target.add((GenericTypeInfo)type);
        }
    }

    public static <T> String getSerializerTree(TypeInformation<T> ti) {
        return Utils.getSerializerTree(ti, 0);
    }

    private static <T> String getSerializerTree(TypeInformation<T> ti, int indent) {
        String ret = "";
        if (ti instanceof CompositeType) {
            ret = ret + StringUtils.repeat((char)' ', (int)indent) + ti.getClass().getSimpleName() + "\n";
            CompositeType cti = (CompositeType)ti;
            String[] fieldNames = cti.getFieldNames();
            for (int i = 0; i < cti.getArity(); ++i) {
                TypeInformation fieldType = cti.getTypeAt(i);
                ret = ret + StringUtils.repeat((char)' ', (int)(indent + 2)) + fieldNames[i] + ":" + Utils.getSerializerTree(fieldType, indent);
            }
        } else if (ti instanceof GenericTypeInfo) {
            ret = ret + StringUtils.repeat((char)' ', (int)indent) + "GenericTypeInfo (" + ti.getTypeClass().getSimpleName() + ")\n";
            ret = ret + Utils.getGenericTypeTree(ti.getTypeClass(), indent + 4);
        } else {
            ret = ret + StringUtils.repeat((char)' ', (int)indent) + ti.toString() + "\n";
        }
        return ret;
    }

    private static String getGenericTypeTree(Class type, int indent) {
        String ret = "";
        for (Field field : type.getDeclaredFields()) {
            if (Modifier.isStatic(field.getModifiers()) || Modifier.isTransient(field.getModifiers())) continue;
            ret = ret + StringUtils.repeat((char)' ', (int)indent) + field.getName() + ":" + field.getType().getName() + (field.getType().isEnum() ? " (is enum)" : "") + "\n";
            if (field.getType().isPrimitive()) continue;
            ret = ret + Utils.getGenericTypeTree(field.getType(), indent + 4);
        }
        return ret;
    }

    private Utils() {
        throw new RuntimeException();
    }

    @FunctionAnnotation.SkipCodeAnalysis
    public static class CollectHelper<T>
    extends RichFlatMapFunction<T, T> {
        private static final long serialVersionUID = 1L;
        private final String id;
        private final TypeSerializer<T> serializer;
        private SerializedListAccumulator<T> accumulator;

        public CollectHelper(String id, TypeSerializer<T> serializer) {
            this.id = id;
            this.serializer = serializer;
        }

        public void open(Configuration parameters) throws Exception {
            this.accumulator = new SerializedListAccumulator();
        }

        public void flatMap(T value, Collector<T> out) throws Exception {
            this.accumulator.add(value, this.serializer);
        }

        public void close() throws Exception {
            this.getRuntimeContext().addAccumulator(this.id, this.accumulator);
        }
    }

    @FunctionAnnotation.SkipCodeAnalysis
    public static class CountHelper<T>
    extends RichFlatMapFunction<T, Long> {
        private static final long serialVersionUID = 1L;
        private final String id;
        private long counter;

        public CountHelper(String id) {
            this.id = id;
            this.counter = 0L;
        }

        public void flatMap(T value, Collector<Long> out) throws Exception {
            ++this.counter;
        }

        public void close() throws Exception {
            this.getRuntimeContext().getLongCounter(this.id).add(this.counter);
        }
    }
}

