/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.hadoop.common;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.flink.api.common.io.RichInputFormat;
import org.apache.flink.core.io.InputSplit;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;

public abstract class HadoopInputFormatCommonBase<T, SPITTYPE extends InputSplit>
extends RichInputFormat<T, SPITTYPE> {
    protected transient Credentials credentials;

    protected HadoopInputFormatCommonBase(Credentials creds) {
        this.credentials = creds;
    }

    protected void write(ObjectOutputStream out) throws IOException {
        this.credentials.write((DataOutput)out);
    }

    public void read(ObjectInputStream in) throws IOException {
        this.credentials = new Credentials();
        this.credentials.readFields((DataInput)in);
    }

    public static Credentials getCredentialsFromUGI(UserGroupInformation ugi) {
        Method getCredentialsMethod = null;
        for (Method m : ugi.getClass().getMethods()) {
            if (!m.getName().equals("getCredentials")) continue;
            getCredentialsMethod = m;
            break;
        }
        if (getCredentialsMethod == null) {
            return null;
        }
        try {
            return (Credentials)getCredentialsMethod.invoke((Object)ugi, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException("Unable to get credentials from UserGroupInformation. This is only supported by Hadoop 2.2.0+");
        }
    }
}

