/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.operators;

import java.util.Arrays;
import org.apache.flink.api.common.InvalidProgramException;
import org.apache.flink.api.common.io.OutputFormat;
import org.apache.flink.api.common.operators.GenericDataSinkBase;
import org.apache.flink.api.common.operators.Operator;
import org.apache.flink.api.common.operators.Order;
import org.apache.flink.api.common.operators.Ordering;
import org.apache.flink.api.common.operators.UnaryOperatorInformation;
import org.apache.flink.api.common.typeinfo.NothingTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.CompositeType;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.operators.Keys;
import org.apache.flink.api.java.typeutils.TupleTypeInfoBase;
import org.apache.flink.configuration.Configuration;

public class DataSink<T> {
    private final OutputFormat<T> format;
    private final TypeInformation<T> type;
    private final DataSet<T> data;
    private String name;
    private int parallelism = -1;
    private Configuration parameters;
    private int[] sortKeyPositions;
    private Order[] sortOrders;

    public DataSink(DataSet<T> data, OutputFormat<T> format, TypeInformation<T> type) {
        if (format == null) {
            throw new IllegalArgumentException("The output format must not be null.");
        }
        if (type == null) {
            throw new IllegalArgumentException("The input type information must not be null.");
        }
        if (data == null) {
            throw new IllegalArgumentException("The data set must not be null.");
        }
        this.format = format;
        this.data = data;
        this.type = type;
    }

    public OutputFormat<T> getFormat() {
        return this.format;
    }

    public TypeInformation<T> getType() {
        return this.type;
    }

    public DataSet<T> getDataSet() {
        return this.data;
    }

    public DataSink<T> withParameters(Configuration parameters) {
        this.parameters = parameters;
        return this;
    }

    public DataSink<T> sortLocalOutput(int field, Order order) {
        Keys.ExpressionKeys<T> ek;
        if (!this.type.isTupleType()) {
            throw new InvalidProgramException("Specifying order keys via field positions is only valid for tuple data types");
        }
        if (field >= this.type.getArity()) {
            throw new InvalidProgramException("Order key out of tuple bounds.");
        }
        this.isValidSortKeyType(field);
        try {
            ek = new Keys.ExpressionKeys<T>(new int[]{field}, this.type);
        }
        catch (IllegalArgumentException iae) {
            throw new InvalidProgramException("Invalid specification of field expression.", (Throwable)iae);
        }
        int[] flatKeys = ek.computeLogicalKeyPositions();
        if (this.sortKeyPositions == null) {
            this.sortKeyPositions = flatKeys;
            this.sortOrders = new Order[flatKeys.length];
            Arrays.fill(this.sortOrders, order);
        } else {
            int oldLength = this.sortKeyPositions.length;
            int newLength = oldLength + flatKeys.length;
            this.sortKeyPositions = Arrays.copyOf(this.sortKeyPositions, newLength);
            this.sortOrders = Arrays.copyOf(this.sortOrders, newLength);
            for (int i = 0; i < flatKeys.length; ++i) {
                this.sortKeyPositions[oldLength + i] = flatKeys[i];
                this.sortOrders[oldLength + i] = order;
            }
        }
        return this;
    }

    public DataSink<T> sortLocalOutput(String fieldExpression, Order order) {
        Object[] orders;
        int numFields;
        int[] fields;
        if (this.type instanceof CompositeType) {
            Keys.ExpressionKeys<T> ek;
            try {
                this.isValidSortKeyType(fieldExpression);
                ek = new Keys.ExpressionKeys<T>(new String[]{fieldExpression}, this.type);
            }
            catch (IllegalArgumentException iae) {
                throw new InvalidProgramException("Invalid specification of field expression.", (Throwable)iae);
            }
            fields = ek.computeLogicalKeyPositions();
            numFields = fields.length;
            orders = new Order[numFields];
            Arrays.fill(orders, order);
        } else {
            if (!(fieldExpression = fieldExpression.trim()).equals("*") && !fieldExpression.equals("_")) {
                throw new InvalidProgramException("Output sorting of non-composite types can only be defined on the full type. Use a field wildcard for that (\"*\" or \"_\")");
            }
            this.isValidSortKeyType(fieldExpression);
            numFields = 1;
            fields = new int[]{0};
            orders = new Order[]{order};
        }
        if (this.sortKeyPositions == null) {
            this.sortKeyPositions = fields;
            this.sortOrders = orders;
        } else {
            int oldLength = this.sortKeyPositions.length;
            int newLength = oldLength + numFields;
            this.sortKeyPositions = Arrays.copyOf(this.sortKeyPositions, newLength);
            this.sortOrders = Arrays.copyOf(this.sortOrders, newLength);
            for (int i = 0; i < numFields; ++i) {
                this.sortKeyPositions[oldLength + i] = fields[i];
                this.sortOrders[oldLength + i] = orders[i];
            }
        }
        return this;
    }

    private void isValidSortKeyType(int field) {
        TypeInformation sortKeyType = ((TupleTypeInfoBase)this.type).getTypeAt(field);
        if (!sortKeyType.isSortKeyType()) {
            throw new InvalidProgramException("Selected sort key is not a sortable type " + sortKeyType);
        }
    }

    private void isValidSortKeyType(String field) {
        TypeInformation sortKeyType = (field = field.trim()).equals("*") || field.equals("_") ? this.type : ((CompositeType)this.type).getTypeAt(field);
        if (!sortKeyType.isSortKeyType()) {
            throw new InvalidProgramException("Selected sort key is not a sortable type " + sortKeyType);
        }
    }

    public Configuration getParameters() {
        return this.parameters;
    }

    public DataSink<T> name(String name) {
        this.name = name;
        return this;
    }

    protected GenericDataSinkBase<T> translateToDataFlow(Operator<T> input) {
        String name = this.name != null ? this.name : this.format.toString();
        GenericDataSinkBase sink = new GenericDataSinkBase(this.format, new UnaryOperatorInformation(this.type, (TypeInformation)new NothingTypeInfo()), name);
        sink.setInput(input);
        if (this.parameters != null) {
            sink.getParameters().addAll(this.parameters);
        }
        if (this.parallelism > 0) {
            sink.setParallelism(this.parallelism);
        } else {
            sink.setParallelism(input.getParallelism());
        }
        if (this.sortKeyPositions != null) {
            Ordering ordering = new Ordering();
            for (int i = 0; i < this.sortKeyPositions.length; ++i) {
                ordering.appendOrdering(Integer.valueOf(this.sortKeyPositions[i]), null, this.sortOrders[i]);
            }
            sink.setLocalOrder(ordering);
        }
        return sink;
    }

    public String toString() {
        return "DataSink '" + (this.name == null ? "<unnamed>" : this.name) + "' (" + this.format.toString() + ")";
    }

    public int getParallelism() {
        return this.parallelism;
    }

    public DataSink<T> setParallelism(int parallelism) {
        if (parallelism < 1) {
            throw new IllegalArgumentException("The parallelism of an operator must be at least 1.");
        }
        this.parallelism = parallelism;
        return this;
    }
}

