/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils.runtime;

import com.esotericsoftware.kryo.Kryo;
import java.io.IOException;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.shaded.com.google.common.base.Preconditions;
import org.apache.flink.types.Value;
import org.apache.flink.util.InstantiationUtil;

public class ValueSerializer<T extends Value>
extends TypeSerializer<T> {
    private static final long serialVersionUID = 1L;
    private final Class<T> type;
    private transient Kryo kryo;
    private transient T copyInstance;

    public ValueSerializer(Class<T> type) {
        this.type = Preconditions.checkNotNull(type);
    }

    public boolean isImmutableType() {
        return false;
    }

    public ValueSerializer<T> duplicate() {
        return new ValueSerializer<T>(this.type);
    }

    public T createInstance() {
        return (T)((Value)InstantiationUtil.instantiate(this.type));
    }

    public T copy(T from) {
        this.checkKryoInitialized();
        return (T)((Value)this.kryo.copy(from));
    }

    public T copy(T from, T reuse) {
        this.checkKryoInitialized();
        return (T)((Value)this.kryo.copy(from));
    }

    public int getLength() {
        return -1;
    }

    public void serialize(T value, DataOutputView target) throws IOException {
        value.write(target);
    }

    public T deserialize(DataInputView source) throws IOException {
        return this.deserialize(this.createInstance(), source);
    }

    public T deserialize(T reuse, DataInputView source) throws IOException {
        reuse.read(source);
        return reuse;
    }

    public void copy(DataInputView source, DataOutputView target) throws IOException {
        if (this.copyInstance == null) {
            this.copyInstance = (Value)InstantiationUtil.instantiate(this.type);
        }
        this.copyInstance.read(source);
        this.copyInstance.write(target);
    }

    private void checkKryoInitialized() {
        if (this.kryo == null) {
            this.kryo = new Kryo();
            this.kryo.setAsmEnabled(true);
            this.kryo.register(this.type);
        }
    }

    public int hashCode() {
        return this.type.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ValueSerializer) {
            ValueSerializer other = (ValueSerializer)((Object)obj);
            return other.canEqual((Object)this) && this.type == other.type;
        }
        return false;
    }

    public boolean canEqual(Object obj) {
        return obj instanceof ValueSerializer;
    }
}

