/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.optimizer;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.flink.api.common.ExecutionMode;
import org.apache.flink.api.common.Plan;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.optimizer.CompilerException;
import org.apache.flink.optimizer.DataStatistics;
import org.apache.flink.optimizer.costs.CostEstimator;
import org.apache.flink.optimizer.costs.DefaultCostEstimator;
import org.apache.flink.optimizer.dag.DataSinkNode;
import org.apache.flink.optimizer.dag.OptimizerNode;
import org.apache.flink.optimizer.dag.SinkJoiner;
import org.apache.flink.optimizer.plan.OptimizedPlan;
import org.apache.flink.optimizer.plan.PlanNode;
import org.apache.flink.optimizer.plan.SinkJoinerPlanNode;
import org.apache.flink.optimizer.plan.SinkPlanNode;
import org.apache.flink.optimizer.postpass.OptimizerPostPass;
import org.apache.flink.optimizer.traversals.BinaryUnionReplacer;
import org.apache.flink.optimizer.traversals.BranchesVisitor;
import org.apache.flink.optimizer.traversals.GraphCreatingVisitor;
import org.apache.flink.optimizer.traversals.IdAndEstimatesVisitor;
import org.apache.flink.optimizer.traversals.InterestingPropertyVisitor;
import org.apache.flink.optimizer.traversals.PlanFinalizer;
import org.apache.flink.util.InstantiationUtil;
import org.apache.flink.util.Visitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Optimizer {
    public static final String HINT_SHIP_STRATEGY = "INPUT_SHIP_STRATEGY";
    public static final String HINT_SHIP_STRATEGY_FIRST_INPUT = "INPUT_LEFT_SHIP_STRATEGY";
    public static final String HINT_SHIP_STRATEGY_SECOND_INPUT = "INPUT_RIGHT_SHIP_STRATEGY";
    public static final String HINT_SHIP_STRATEGY_FORWARD = "SHIP_FORWARD";
    public static final String HINT_SHIP_STRATEGY_REPARTITION = "SHIP_REPARTITION";
    public static final String HINT_SHIP_STRATEGY_REPARTITION_HASH = "SHIP_REPARTITION_HASH";
    public static final String HINT_SHIP_STRATEGY_REPARTITION_RANGE = "SHIP_REPARTITION_RANGE";
    public static final String HINT_SHIP_STRATEGY_BROADCAST = "SHIP_BROADCAST";
    public static final String HINT_LOCAL_STRATEGY = "LOCAL_STRATEGY";
    public static final String HINT_LOCAL_STRATEGY_SORT = "LOCAL_STRATEGY_SORT";
    public static final String HINT_LOCAL_STRATEGY_COMBINING_SORT = "LOCAL_STRATEGY_COMBINING_SORT";
    public static final String HINT_LOCAL_STRATEGY_SORT_BOTH_MERGE = "LOCAL_STRATEGY_SORT_BOTH_MERGE";
    public static final String HINT_LOCAL_STRATEGY_SORT_FIRST_MERGE = "LOCAL_STRATEGY_SORT_FIRST_MERGE";
    public static final String HINT_LOCAL_STRATEGY_SORT_SECOND_MERGE = "LOCAL_STRATEGY_SORT_SECOND_MERGE";
    public static final String HINT_LOCAL_STRATEGY_MERGE = "LOCAL_STRATEGY_MERGE";
    public static final String HINT_LOCAL_STRATEGY_HASH_BUILD_FIRST = "LOCAL_STRATEGY_HASH_BUILD_FIRST";
    public static final String HINT_LOCAL_STRATEGY_HASH_BUILD_SECOND = "LOCAL_STRATEGY_HASH_BUILD_SECOND";
    public static final String HINT_LOCAL_STRATEGY_NESTEDLOOP_STREAMED_OUTER_FIRST = "LOCAL_STRATEGY_NESTEDLOOP_STREAMED_OUTER_FIRST";
    public static final String HINT_LOCAL_STRATEGY_NESTEDLOOP_STREAMED_OUTER_SECOND = "LOCAL_STRATEGY_NESTEDLOOP_STREAMED_OUTER_SECOND";
    public static final String HINT_LOCAL_STRATEGY_NESTEDLOOP_BLOCKED_OUTER_FIRST = "LOCAL_STRATEGY_NESTEDLOOP_BLOCKED_OUTER_FIRST";
    public static final String HINT_LOCAL_STRATEGY_NESTEDLOOP_BLOCKED_OUTER_SECOND = "LOCAL_STRATEGY_NESTEDLOOP_BLOCKED_OUTER_SECOND";
    public static final Logger LOG = LoggerFactory.getLogger(Optimizer.class);
    private final DataStatistics statistics;
    private final CostEstimator costEstimator;
    private int defaultParallelism;

    public Optimizer(Configuration config) {
        this(null, new DefaultCostEstimator(), config);
    }

    public Optimizer(DataStatistics stats, Configuration config) {
        this(stats, new DefaultCostEstimator(), config);
    }

    public Optimizer(CostEstimator estimator, Configuration config) {
        this(null, estimator, config);
    }

    public Optimizer(DataStatistics stats, CostEstimator estimator, Configuration config) {
        this.statistics = stats;
        this.costEstimator = estimator;
        this.defaultParallelism = config.getInteger("parallelism.default", 1);
        if (this.defaultParallelism < 1) {
            LOG.warn("Config value " + this.defaultParallelism + " for option " + 1 + " is invalid. Ignoring and using a value of 1.");
            this.defaultParallelism = 1;
        }
    }

    public int getDefaultParallelism() {
        return this.defaultParallelism;
    }

    public void setDefaultParallelism(int defaultParallelism) {
        if (defaultParallelism <= 0) {
            throw new IllegalArgumentException("Default parallelism cannot be zero or negative.");
        }
        this.defaultParallelism = defaultParallelism;
    }

    public OptimizedPlan compile(Plan program) throws CompilerException {
        OptimizerPostPass postPasser = this.getPostPassFromPlan(program);
        return this.compile(program, postPasser);
    }

    private OptimizedPlan compile(Plan program, OptimizerPostPass postPasser) throws CompilerException {
        OptimizerNode rootNode;
        if (program == null || postPasser == null) {
            throw new NullPointerException();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Beginning compilation of program '" + program.getJobName() + '\'');
        }
        ExecutionMode defaultDataExchangeMode = program.getExecutionConfig().getExecutionMode();
        int defaultParallelism = program.getDefaultParallelism() > 0 ? program.getDefaultParallelism() : this.defaultParallelism;
        LOG.debug("Using a default parallelism of {}", (Object)defaultParallelism);
        LOG.debug("Using default data exchange mode {}", (Object)defaultDataExchangeMode);
        GraphCreatingVisitor graphCreator = new GraphCreatingVisitor(defaultParallelism, defaultDataExchangeMode);
        program.accept((Visitor)graphCreator);
        if (graphCreator.getSinks().size() == 1) {
            rootNode = graphCreator.getSinks().get(0);
        } else if (graphCreator.getSinks().size() > 1) {
            Iterator<DataSinkNode> iter = graphCreator.getSinks().iterator();
            rootNode = iter.next();
            while (iter.hasNext()) {
                rootNode = new SinkJoiner(rootNode, iter.next());
            }
        } else {
            throw new CompilerException("Bug: The optimizer plan representation has no sinks.");
        }
        rootNode.accept(new IdAndEstimatesVisitor(this.statistics));
        BranchesVisitor branchingVisitor = new BranchesVisitor();
        rootNode.accept(branchingVisitor);
        InterestingPropertyVisitor propsVisitor = new InterestingPropertyVisitor(this.costEstimator);
        rootNode.accept(propsVisitor);
        if (rootNode.getOpenBranches() != null && rootNode.getOpenBranches().size() > 0) {
            throw new CompilerException("Bug: Logic for branching plans (non-tree plans) has an error, and does not track the re-joining of branches correctly.");
        }
        List<PlanNode> bestPlan = rootNode.getAlternativePlans(this.costEstimator);
        if (bestPlan.size() != 1) {
            throw new CompilerException("Error in compiler: more than one best plan was created!");
        }
        PlanNode bestPlanRoot = bestPlan.get(0);
        ArrayList<SinkPlanNode> bestPlanSinks = new ArrayList<SinkPlanNode>(4);
        if (bestPlanRoot instanceof SinkPlanNode) {
            bestPlanSinks.add((SinkPlanNode)bestPlanRoot);
        } else if (bestPlanRoot instanceof SinkJoinerPlanNode) {
            ((SinkJoinerPlanNode)bestPlanRoot).getDataSinks(bestPlanSinks);
        }
        OptimizedPlan plan = new PlanFinalizer().createFinalPlan(bestPlanSinks, program.getJobName(), program);
        plan.accept(new BinaryUnionReplacer());
        postPasser.postPass(plan);
        return plan;
    }

    public static List<DataSinkNode> createPreOptimizedPlan(Plan program) {
        GraphCreatingVisitor graphCreator = new GraphCreatingVisitor(1, null);
        program.accept((Visitor)graphCreator);
        return graphCreator.getSinks();
    }

    private OptimizerPostPass getPostPassFromPlan(Plan program) {
        String className = program.getPostPassClassName();
        if (className == null) {
            throw new CompilerException("Optimizer Post Pass class description is null");
        }
        try {
            Class<OptimizerPostPass> clazz = Class.forName(className).asSubclass(OptimizerPostPass.class);
            try {
                return (OptimizerPostPass)InstantiationUtil.instantiate(clazz, OptimizerPostPass.class);
            }
            catch (RuntimeException rtex) {
                if (rtex.getCause() != null) {
                    throw new CompilerException("Cannot instantiate optimizer post pass: " + rtex.getMessage(), rtex.getCause());
                }
                throw rtex;
            }
        }
        catch (ClassNotFoundException cnfex) {
            throw new CompilerException("Cannot load Optimizer post-pass class '" + className + "'.", cnfex);
        }
        catch (ClassCastException ccex) {
            throw new CompilerException("Class '" + className + "' is not an optimizer post-pass.", ccex);
        }
    }
}

