/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.util.UUID;
import org.apache.flink.runtime.akka.FlinkUntypedActor;
import org.apache.flink.runtime.checkpoint.CheckpointCoordinator;
import org.apache.flink.runtime.jobgraph.JobStatus;
import org.apache.flink.runtime.messages.ExecutionGraphMessages;
import org.apache.flink.shaded.com.google.common.base.Preconditions;

public class CheckpointCoordinatorDeActivator
extends FlinkUntypedActor {
    private final CheckpointCoordinator coordinator;
    private final long interval;
    private final UUID leaderSessionID;

    public CheckpointCoordinatorDeActivator(CheckpointCoordinator coordinator, long interval, UUID leaderSessionID) {
        this.LOG.info("Create CheckpointCoordinatorDeActivator");
        this.coordinator = Preconditions.checkNotNull(coordinator, "The checkpointCoordinator must not be null.");
        this.interval = interval;
        this.leaderSessionID = leaderSessionID;
    }

    @Override
    public void handleMessage(Object message) {
        if (message instanceof ExecutionGraphMessages.JobStatusChanged) {
            JobStatus status = ((ExecutionGraphMessages.JobStatusChanged)message).newJobStatus();
            if (status == JobStatus.RUNNING) {
                this.coordinator.startPeriodicCheckpointScheduler(this.interval);
            } else {
                this.coordinator.stopPeriodicCheckpointScheduler();
            }
        }
    }

    @Override
    public UUID getLeaderSessionID() {
        return this.leaderSessionID;
    }
}

