/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import org.apache.flink.runtime.checkpoint.CheckpointIDCounter;
import org.apache.flink.shaded.com.google.common.base.Preconditions;
import org.apache.flink.shaded.org.apache.curator.framework.CuratorFramework;
import org.apache.flink.shaded.org.apache.curator.framework.api.Pathable;
import org.apache.flink.shaded.org.apache.curator.framework.recipes.shared.SharedCount;
import org.apache.flink.shaded.org.apache.curator.framework.recipes.shared.VersionedValue;
import org.apache.flink.shaded.org.apache.curator.framework.state.ConnectionState;
import org.apache.flink.shaded.org.apache.curator.framework.state.ConnectionStateListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZooKeeperCheckpointIDCounter
implements CheckpointIDCounter {
    private static final Logger LOG = LoggerFactory.getLogger(ZooKeeperCheckpointIDCounter.class);
    private final CuratorFramework client;
    private final String counterPath;
    private final SharedCount sharedCount;
    private final SharedCountConnectionStateListener connStateListener = new SharedCountConnectionStateListener();

    public ZooKeeperCheckpointIDCounter(CuratorFramework client, String counterPath) throws Exception {
        this.client = Preconditions.checkNotNull(client, "Curator client");
        this.counterPath = Preconditions.checkNotNull(counterPath, "Counter path");
        this.sharedCount = new SharedCount(client, counterPath, 1);
    }

    @Override
    public void start() throws Exception {
        this.sharedCount.start();
        this.client.getConnectionStateListenable().addListener(this.connStateListener);
    }

    @Override
    public void stop() throws Exception {
        this.sharedCount.close();
        this.client.getConnectionStateListenable().removeListener(this.connStateListener);
        LOG.info("Removing {} from ZooKeeper", (Object)this.counterPath);
        ((Pathable)this.client.delete().deletingChildrenIfNeeded().inBackground()).forPath(this.counterPath);
    }

    @Override
    public long getAndIncrement() throws Exception {
        Integer newCount;
        VersionedValue<Integer> current;
        do {
            ConnectionState connState;
            if ((connState = this.connStateListener.getLastState()) == null) continue;
            throw new IllegalStateException("Connection state: " + (Object)((Object)connState));
        } while (!this.sharedCount.trySetCount(current = this.sharedCount.getVersionedValue(), newCount = Integer.valueOf(current.getValue() + 1)));
        return current.getValue().intValue();
    }

    private class SharedCountConnectionStateListener
    implements ConnectionStateListener {
        private volatile ConnectionState lastState;

        private SharedCountConnectionStateListener() {
        }

        @Override
        public void stateChanged(CuratorFramework client, ConnectionState newState) {
            if (newState == ConnectionState.SUSPENDED || newState == ConnectionState.LOST) {
                this.lastState = newState;
            }
        }

        private ConnectionState getLastState() {
            return this.lastState;
        }
    }
}

