/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.deployment;

import java.io.Serializable;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import org.apache.flink.api.common.JobID;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.blob.BlobKey;
import org.apache.flink.runtime.deployment.InputGateDeploymentDescriptor;
import org.apache.flink.runtime.deployment.ResultPartitionDeploymentDescriptor;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.state.StateHandle;
import org.apache.flink.shaded.com.google.common.base.Preconditions;
import org.apache.flink.util.SerializedValue;

public final class TaskDeploymentDescriptor
implements Serializable {
    private static final long serialVersionUID = -3233562176034358530L;
    private final JobID jobID;
    private final JobVertexID vertexID;
    private final ExecutionAttemptID executionId;
    private final String taskName;
    private final int indexInSubtaskGroup;
    private final int numberOfSubtasks;
    private final Configuration jobConfiguration;
    private final Configuration taskConfiguration;
    private final String invokableClassName;
    private final List<ResultPartitionDeploymentDescriptor> producedPartitions;
    private final List<InputGateDeploymentDescriptor> inputGates;
    private final int targetSlotNumber;
    private final List<BlobKey> requiredJarFiles;
    private final List<URL> requiredClasspaths;
    private final SerializedValue<StateHandle<?>> operatorState;

    public TaskDeploymentDescriptor(JobID jobID, JobVertexID vertexID, ExecutionAttemptID executionId, String taskName, int indexInSubtaskGroup, int numberOfSubtasks, Configuration jobConfiguration, Configuration taskConfiguration, String invokableClassName, List<ResultPartitionDeploymentDescriptor> producedPartitions, List<InputGateDeploymentDescriptor> inputGates, List<BlobKey> requiredJarFiles, List<URL> requiredClasspaths, int targetSlotNumber, SerializedValue<StateHandle<?>> operatorState) {
        Preconditions.checkArgument(indexInSubtaskGroup >= 0);
        Preconditions.checkArgument(numberOfSubtasks > indexInSubtaskGroup);
        Preconditions.checkArgument(targetSlotNumber >= 0);
        this.jobID = Preconditions.checkNotNull(jobID);
        this.vertexID = Preconditions.checkNotNull(vertexID);
        this.executionId = Preconditions.checkNotNull(executionId);
        this.taskName = Preconditions.checkNotNull(taskName);
        this.indexInSubtaskGroup = indexInSubtaskGroup;
        this.numberOfSubtasks = numberOfSubtasks;
        this.jobConfiguration = Preconditions.checkNotNull(jobConfiguration);
        this.taskConfiguration = Preconditions.checkNotNull(taskConfiguration);
        this.invokableClassName = Preconditions.checkNotNull(invokableClassName);
        this.producedPartitions = Preconditions.checkNotNull(producedPartitions);
        this.inputGates = Preconditions.checkNotNull(inputGates);
        this.requiredJarFiles = Preconditions.checkNotNull(requiredJarFiles);
        this.requiredClasspaths = Preconditions.checkNotNull(requiredClasspaths);
        this.targetSlotNumber = targetSlotNumber;
        this.operatorState = operatorState;
    }

    public TaskDeploymentDescriptor(JobID jobID, JobVertexID vertexID, ExecutionAttemptID executionId, String taskName, int indexInSubtaskGroup, int numberOfSubtasks, Configuration jobConfiguration, Configuration taskConfiguration, String invokableClassName, List<ResultPartitionDeploymentDescriptor> producedPartitions, List<InputGateDeploymentDescriptor> inputGates, List<BlobKey> requiredJarFiles, List<URL> requiredClasspaths, int targetSlotNumber) {
        this(jobID, vertexID, executionId, taskName, indexInSubtaskGroup, numberOfSubtasks, jobConfiguration, taskConfiguration, invokableClassName, producedPartitions, inputGates, requiredJarFiles, requiredClasspaths, targetSlotNumber, null);
    }

    public JobID getJobID() {
        return this.jobID;
    }

    public JobVertexID getVertexID() {
        return this.vertexID;
    }

    public ExecutionAttemptID getExecutionId() {
        return this.executionId;
    }

    public String getTaskName() {
        return this.taskName;
    }

    public int getIndexInSubtaskGroup() {
        return this.indexInSubtaskGroup;
    }

    public int getNumberOfSubtasks() {
        return this.numberOfSubtasks;
    }

    public int getTargetSlotNumber() {
        return this.targetSlotNumber;
    }

    public Configuration getJobConfiguration() {
        return this.jobConfiguration;
    }

    public Configuration getTaskConfiguration() {
        return this.taskConfiguration;
    }

    public String getInvokableClassName() {
        return this.invokableClassName;
    }

    public List<ResultPartitionDeploymentDescriptor> getProducedPartitions() {
        return this.producedPartitions;
    }

    public List<InputGateDeploymentDescriptor> getInputGates() {
        return this.inputGates;
    }

    public List<BlobKey> getRequiredJarFiles() {
        return this.requiredJarFiles;
    }

    public List<URL> getRequiredClasspaths() {
        return this.requiredClasspaths;
    }

    public String toString() {
        return String.format("TaskDeploymentDescriptor [job id: %s, job vertex id: %s, execution id: %s, task name: %s (%d/%d), invokable: %s, produced partitions: %s, input gates: %s]", new Object[]{this.jobID, this.vertexID, this.executionId, this.taskName, this.indexInSubtaskGroup, this.numberOfSubtasks, this.invokableClassName, this.collectionToString(this.producedPartitions), this.collectionToString(this.inputGates)});
    }

    private String collectionToString(Collection<?> collection) {
        StringBuilder strBuilder = new StringBuilder();
        strBuilder.append("[");
        for (Object elem : collection) {
            strBuilder.append(elem.toString());
        }
        strBuilder.append("]");
        return strBuilder.toString();
    }

    public SerializedValue<StateHandle<?>> getOperatorState() {
        return this.operatorState;
    }
}

