/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobgraph.tasks;

import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.execution.Environment;
import org.apache.flink.util.InstantiationUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractInvokable {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractInvokable.class);
    private Environment environment;
    private ExecutionConfig executionConfig;

    public abstract void registerInputOutput() throws Exception;

    public abstract void invoke() throws Exception;

    public final void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public ClassLoader getUserCodeClassLoader() {
        return this.getEnvironment().getUserClassLoader();
    }

    public int getCurrentNumberOfSubtasks() {
        return this.environment.getNumberOfSubtasks();
    }

    public int getIndexInSubtaskGroup() {
        return this.environment.getIndexInSubtaskGroup();
    }

    public Configuration getTaskConfiguration() {
        return this.environment.getTaskConfiguration();
    }

    public Configuration getJobConfiguration() {
        return this.environment.getJobConfiguration();
    }

    public ExecutionConfig getExecutionConfig() {
        if (this.executionConfig != null) {
            return this.executionConfig;
        }
        try {
            this.executionConfig = (ExecutionConfig)InstantiationUtil.readObjectFromConfig((Configuration)this.getJobConfiguration(), (String)"runtime.config", (ClassLoader)this.getUserCodeClassLoader());
            if (this.executionConfig == null) {
                LOG.warn("Environment did not contain an ExecutionConfig - using a default config.");
                this.executionConfig = new ExecutionConfig();
            }
            return this.executionConfig;
        }
        catch (Exception e) {
            LOG.warn("Could not load ExecutionConfig from Environment, returning default ExecutionConfig", e);
            return new ExecutionConfig();
        }
    }

    public void cancel() throws Exception {
    }
}

