/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.messages.checkpoint;

import java.io.Serializable;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.messages.checkpoint.AbstractCheckpointMessage;
import org.apache.flink.runtime.state.StateHandle;
import org.apache.flink.util.SerializedValue;

public class AcknowledgeCheckpoint
extends AbstractCheckpointMessage
implements Serializable {
    private static final long serialVersionUID = -7606214777192401493L;
    private final SerializedValue<StateHandle<?>> state;

    public AcknowledgeCheckpoint(JobID job, ExecutionAttemptID taskExecutionId, long checkpointId) {
        this(job, taskExecutionId, checkpointId, null);
    }

    public AcknowledgeCheckpoint(JobID job, ExecutionAttemptID taskExecutionId, long checkpointId, SerializedValue<StateHandle<?>> state) {
        super(job, taskExecutionId, checkpointId);
        this.state = state;
    }

    public SerializedValue<StateHandle<?>> getState() {
        return this.state;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof AcknowledgeCheckpoint) {
            AcknowledgeCheckpoint that = (AcknowledgeCheckpoint)o;
            return super.equals(o) && (this.state == null ? that.state == null : that.state != null && this.state.equals(that.state));
        }
        return false;
    }

    @Override
    public String toString() {
        return String.format("Confirm Task Checkpoint %d for (%s/%s) - state=%s", new Object[]{this.getCheckpointId(), this.getJob(), this.getTaskExecutionId(), this.state});
    }
}

