/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators;

import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.functions.FlatJoinFunction;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.api.common.typeutils.TypePairComparatorFactory;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.runtime.io.disk.iomanager.IOManager;
import org.apache.flink.runtime.memory.MemoryManager;
import org.apache.flink.runtime.operators.Driver;
import org.apache.flink.runtime.operators.DriverStrategy;
import org.apache.flink.runtime.operators.TaskContext;
import org.apache.flink.runtime.operators.hash.NonReusingBuildFirstHashJoinIterator;
import org.apache.flink.runtime.operators.hash.NonReusingBuildSecondHashJoinIterator;
import org.apache.flink.runtime.operators.hash.ReusingBuildFirstHashJoinIterator;
import org.apache.flink.runtime.operators.hash.ReusingBuildSecondHashJoinIterator;
import org.apache.flink.runtime.operators.sort.NonReusingMergeInnerJoinIterator;
import org.apache.flink.runtime.operators.sort.ReusingMergeInnerJoinIterator;
import org.apache.flink.runtime.operators.util.JoinTaskIterator;
import org.apache.flink.runtime.operators.util.TaskConfig;
import org.apache.flink.util.Collector;
import org.apache.flink.util.MutableObjectIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JoinDriver<IT1, IT2, OT>
implements Driver<FlatJoinFunction<IT1, IT2, OT>, OT> {
    protected static final Logger LOG = LoggerFactory.getLogger(JoinDriver.class);
    protected TaskContext<FlatJoinFunction<IT1, IT2, OT>, OT> taskContext;
    private volatile JoinTaskIterator<IT1, IT2, OT> joinIterator;
    protected volatile boolean running;

    @Override
    public void setup(TaskContext<FlatJoinFunction<IT1, IT2, OT>, OT> context) {
        this.taskContext = context;
        this.running = true;
    }

    @Override
    public int getNumberOfInputs() {
        return 2;
    }

    @Override
    public Class<FlatJoinFunction<IT1, IT2, OT>> getStubType() {
        Class<FlatJoinFunction> clazz = FlatJoinFunction.class;
        return clazz;
    }

    @Override
    public int getNumberOfDriverComparators() {
        return 2;
    }

    @Override
    public void prepare() throws Exception {
        block14: {
            boolean hashJoinUseBitMaps;
            TypePairComparatorFactory pairComparatorFactory;
            TypeComparator comparator2;
            TypeComparator comparator1;
            TypeSerializer serializer2;
            TypeSerializer serializer1;
            MutableObjectIterator in2;
            MutableObjectIterator in1;
            DriverStrategy ls;
            int numPages;
            double fractionAvailableMemory;
            IOManager ioManager;
            MemoryManager memoryManager;
            block13: {
                TaskConfig config = this.taskContext.getTaskConfig();
                memoryManager = this.taskContext.getMemoryManager();
                ioManager = this.taskContext.getIOManager();
                fractionAvailableMemory = config.getRelativeMemoryDriver();
                numPages = memoryManager.computeNumberOfPages(fractionAvailableMemory);
                ls = config.getDriverStrategy();
                in1 = this.taskContext.getInput(0);
                in2 = this.taskContext.getInput(1);
                serializer1 = this.taskContext.getInputSerializer(0).getSerializer();
                serializer2 = this.taskContext.getInputSerializer(1).getSerializer();
                comparator1 = this.taskContext.getDriverComparator(0);
                comparator2 = this.taskContext.getDriverComparator(1);
                pairComparatorFactory = config.getPairComparatorFactory(this.taskContext.getUserCodeClassLoader());
                if (pairComparatorFactory == null) {
                    throw new Exception("Missing pair comparator factory for join driver");
                }
                ExecutionConfig executionConfig = this.taskContext.getExecutionConfig();
                boolean objectReuseEnabled = executionConfig.isObjectReuseEnabled();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Join Driver object reuse: " + (objectReuseEnabled ? "ENABLED" : "DISABLED") + ".");
                }
                hashJoinUseBitMaps = this.taskContext.getTaskManagerInfo().getConfiguration().getBoolean("taskmanager.runtime.hashjoin-bloom-filters", false);
                if (!objectReuseEnabled) break block13;
                switch (ls) {
                    case INNER_MERGE: {
                        this.joinIterator = new ReusingMergeInnerJoinIterator(in1, in2, serializer1, comparator1, serializer2, comparator2, pairComparatorFactory.createComparator12(comparator1, comparator2), memoryManager, ioManager, numPages, this.taskContext.getOwningNepheleTask());
                        break block14;
                    }
                    case HYBRIDHASH_BUILD_FIRST: {
                        this.joinIterator = new ReusingBuildFirstHashJoinIterator(in1, in2, serializer1, comparator1, serializer2, comparator2, pairComparatorFactory.createComparator21(comparator1, comparator2), memoryManager, ioManager, this.taskContext.getOwningNepheleTask(), fractionAvailableMemory, false, hashJoinUseBitMaps);
                        break block14;
                    }
                    case HYBRIDHASH_BUILD_SECOND: {
                        this.joinIterator = new ReusingBuildSecondHashJoinIterator(in1, in2, serializer1, comparator1, serializer2, comparator2, pairComparatorFactory.createComparator12(comparator1, comparator2), memoryManager, ioManager, this.taskContext.getOwningNepheleTask(), fractionAvailableMemory, false, hashJoinUseBitMaps);
                        break block14;
                    }
                    default: {
                        throw new Exception("Unsupported driver strategy for join driver: " + ls.name());
                    }
                }
            }
            switch (ls) {
                case INNER_MERGE: {
                    this.joinIterator = new NonReusingMergeInnerJoinIterator(in1, in2, serializer1, comparator1, serializer2, comparator2, pairComparatorFactory.createComparator12(comparator1, comparator2), memoryManager, ioManager, numPages, this.taskContext.getOwningNepheleTask());
                    break;
                }
                case HYBRIDHASH_BUILD_FIRST: {
                    this.joinIterator = new NonReusingBuildFirstHashJoinIterator(in1, in2, serializer1, comparator1, serializer2, comparator2, pairComparatorFactory.createComparator21(comparator1, comparator2), memoryManager, ioManager, this.taskContext.getOwningNepheleTask(), fractionAvailableMemory, false, hashJoinUseBitMaps);
                    break;
                }
                case HYBRIDHASH_BUILD_SECOND: {
                    this.joinIterator = new NonReusingBuildSecondHashJoinIterator(in1, in2, serializer1, comparator1, serializer2, comparator2, pairComparatorFactory.createComparator12(comparator1, comparator2), memoryManager, ioManager, this.taskContext.getOwningNepheleTask(), fractionAvailableMemory, false, hashJoinUseBitMaps);
                    break;
                }
                default: {
                    throw new Exception("Unsupported driver strategy for join driver: " + ls.name());
                }
            }
        }
        this.joinIterator.open();
        if (LOG.isDebugEnabled()) {
            LOG.debug(this.taskContext.formatLogString("join task iterator ready."));
        }
    }

    @Override
    public void run() throws Exception {
        FlatJoinFunction<IT1, IT2, OT> joinStub = this.taskContext.getStub();
        Collector<OT> collector = this.taskContext.getOutputCollector();
        JoinTaskIterator<IT1, IT2, OT> joinIterator = this.joinIterator;
        while (this.running && joinIterator.callWithNextKey(joinStub, collector)) {
        }
    }

    @Override
    public void cleanup() throws Exception {
        if (this.joinIterator != null) {
            this.joinIterator.close();
            this.joinIterator = null;
        }
    }

    @Override
    public void cancel() {
        this.running = false;
        if (this.joinIterator != null) {
            this.joinIterator.abort();
        }
    }
}

