/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators.chaining;

import org.apache.flink.api.common.functions.GenericCollectorMap;
import org.apache.flink.api.common.functions.RichFunction;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.jobgraph.tasks.AbstractInvokable;
import org.apache.flink.runtime.operators.BatchTask;
import org.apache.flink.runtime.operators.chaining.ChainedDriver;
import org.apache.flink.runtime.operators.chaining.ExceptionInChainedStubException;

public class ChainedCollectorMapDriver<IT, OT>
extends ChainedDriver<IT, OT> {
    private GenericCollectorMap<IT, OT> mapper;

    @Override
    public void setup(AbstractInvokable parent) {
        GenericCollectorMap mapper;
        this.mapper = mapper = BatchTask.instantiateUserCode(this.config, this.userCodeClassLoader, GenericCollectorMap.class);
        mapper.setRuntimeContext(this.getUdfRuntimeContext());
    }

    @Override
    public void openTask() throws Exception {
        Configuration stubConfig = this.config.getStubParameters();
        BatchTask.openUserCode(this.mapper, stubConfig);
    }

    @Override
    public void closeTask() throws Exception {
        BatchTask.closeUserCode(this.mapper);
    }

    @Override
    public void cancelTask() {
        try {
            this.mapper.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public RichFunction getStub() {
        return this.mapper;
    }

    @Override
    public String getTaskName() {
        return this.taskName;
    }

    @Override
    public void collect(IT record) {
        try {
            this.mapper.map(record, this.outputCollector);
        }
        catch (Exception ex) {
            throw new ExceptionInChainedStubException(this.taskName, ex);
        }
    }

    public void close() {
        this.outputCollector.close();
    }
}

