/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators.hash;

import java.io.IOException;
import java.util.List;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.api.common.typeutils.TypePairComparator;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.runtime.io.disk.iomanager.IOManager;
import org.apache.flink.runtime.jobgraph.tasks.AbstractInvokable;
import org.apache.flink.runtime.memory.MemoryAllocationException;
import org.apache.flink.runtime.memory.MemoryManager;
import org.apache.flink.runtime.operators.hash.MutableHashTable;
import org.apache.flink.runtime.operators.hash.ReOpenableMutableHashTable;
import org.apache.flink.runtime.operators.hash.ReusingBuildSecondHashJoinIterator;
import org.apache.flink.util.MutableObjectIterator;

public class ReusingBuildSecondReOpenableHashJoinIterator<V1, V2, O>
extends ReusingBuildSecondHashJoinIterator<V1, V2, O> {
    private final ReOpenableMutableHashTable<V2, V1> reopenHashTable;

    public ReusingBuildSecondReOpenableHashJoinIterator(MutableObjectIterator<V1> firstInput, MutableObjectIterator<V2> secondInput, TypeSerializer<V1> serializer1, TypeComparator<V1> comparator1, TypeSerializer<V2> serializer2, TypeComparator<V2> comparator2, TypePairComparator<V1, V2> pairComparator, MemoryManager memManager, IOManager ioManager, AbstractInvokable ownerTask, double memoryFraction, boolean joinWithEmptyBuildSide, boolean useBitmapFilters) throws MemoryAllocationException {
        super(firstInput, secondInput, serializer1, comparator1, serializer2, comparator2, pairComparator, memManager, ioManager, ownerTask, memoryFraction, joinWithEmptyBuildSide, useBitmapFilters);
        this.reopenHashTable = (ReOpenableMutableHashTable)this.hashJoin;
    }

    @Override
    public <BT, PT> MutableHashTable<BT, PT> getHashJoin(TypeSerializer<BT> buildSideSerializer, TypeComparator<BT> buildSideComparator, TypeSerializer<PT> probeSideSerializer, TypeComparator<PT> probeSideComparator, TypePairComparator<PT, BT> pairComparator, MemoryManager memManager, IOManager ioManager, AbstractInvokable ownerTask, double memoryFraction, boolean useBitmapFilters) throws MemoryAllocationException {
        int numPages = memManager.computeNumberOfPages(memoryFraction);
        List<MemorySegment> memorySegments = memManager.allocatePages(ownerTask, numPages);
        return new ReOpenableMutableHashTable<BT, PT>(buildSideSerializer, probeSideSerializer, buildSideComparator, probeSideComparator, pairComparator, memorySegments, ioManager, useBitmapFilters);
    }

    public void reopenProbe(MutableObjectIterator<V1> probeInput) throws IOException {
        this.reopenHashTable.reopenProbe(probeInput);
    }
}

