/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.filesystem;

import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;

public abstract class AbstractFileState
implements Serializable {
    private static final long serialVersionUID = 350284443258002355L;
    private final Path filePath;
    private transient FileSystem fs;

    protected AbstractFileState(Path filePath) {
        this.filePath = filePath;
    }

    public Path getFilePath() {
        return this.filePath;
    }

    public void discardState() throws Exception {
        this.getFileSystem().delete(this.filePath, false);
        try {
            this.getFileSystem().delete(this.filePath.getParent(), false);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected FileSystem getFileSystem() throws IOException {
        if (this.fs == null) {
            this.fs = FileSystem.get((URI)this.filePath.toUri());
        }
        return this.fs;
    }
}

